/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AssetReportType;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fired when the Asset Report has been generated and `/asset_report/get` is ready to be called.  If you attempt to retrieve an Asset Report before this webhook has fired, you\u2019ll receive a response with the HTTP status code 400 and a Plaid error code of `PRODUCT_NOT_READY`.")
public class AssetsProductReadyWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_ASSET_REPORT_ID = "asset_report_id";
    @SerializedName(value="asset_report_id")
    private String assetReportId;
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(value="user_id")
    private String userId;
    public static final String SERIALIZED_NAME_REPORT_TYPE = "report_type";
    @SerializedName(value="report_type")
    private AssetReportType reportType;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public AssetsProductReadyWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`ASSETS`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public AssetsProductReadyWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`PRODUCT_READY`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public AssetsProductReadyWebhook assetReportId(String assetReportId) {
        this.assetReportId = assetReportId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `asset_report_id` corresponding to the Asset Report the webhook has fired for.")
    public String getAssetReportId() {
        return this.assetReportId;
    }

    public void setAssetReportId(String assetReportId) {
        this.assetReportId = assetReportId;
    }

    public AssetsProductReadyWebhook userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `user_id` corresponding to the User ID the webhook has fired for.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public AssetsProductReadyWebhook reportType(AssetReportType reportType) {
        this.reportType = reportType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AssetReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(AssetReportType reportType) {
        this.reportType = reportType;
    }

    public AssetsProductReadyWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetsProductReadyWebhook assetsProductReadyWebhook = (AssetsProductReadyWebhook)o;
        return Objects.equals(this.webhookType, assetsProductReadyWebhook.webhookType) && Objects.equals(this.webhookCode, assetsProductReadyWebhook.webhookCode) && Objects.equals(this.assetReportId, assetsProductReadyWebhook.assetReportId) && Objects.equals(this.userId, assetsProductReadyWebhook.userId) && Objects.equals((Object)this.reportType, (Object)assetsProductReadyWebhook.reportType) && Objects.equals((Object)this.environment, (Object)assetsProductReadyWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.assetReportId, this.userId, this.reportType, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetsProductReadyWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    assetReportId: ").append(this.toIndentedString(this.assetReportId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    reportType: ").append(this.toIndentedString((Object)this.reportType)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

