/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AuthUpdateTypes;
import com.plaid.client.model.PlaidError;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Plaid will trigger a `DEFAULT_UPDATE` webhook for Items that undergo a change in Auth data. This is generally caused by data partners notifying Plaid of a change in their account numbering system or to their routing numbers. To avoid returned transactions, customers that receive a `DEFAULT_UPDATE` webhook with the `account_ids_with_updated_auth` object populated should immediately discontinue all usages of existing Auth data for those accounts and call `/auth/get` or `/processor/auth/get` to obtain updated account and routing numbers.")
public class AuthDefaultUpdateWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_ACCOUNT_IDS_WITH_NEW_AUTH = "account_ids_with_new_auth";
    @SerializedName(value="account_ids_with_new_auth")
    private List<String> accountIdsWithNewAuth = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ACCOUNT_IDS_WITH_UPDATED_AUTH = "account_ids_with_updated_auth";
    @SerializedName(value="account_ids_with_updated_auth")
    private Map<String, List<AuthUpdateTypes>> accountIdsWithUpdatedAuth = new HashMap<String, List<AuthUpdateTypes>>();
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private PlaidError error;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public AuthDefaultUpdateWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`AUTH`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public AuthDefaultUpdateWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`DEFAULT_UPDATE`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public AuthDefaultUpdateWebhook itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `item_id` of the Item associated with this webhook, warning, or error")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public AuthDefaultUpdateWebhook accountIdsWithNewAuth(List<String> accountIdsWithNewAuth) {
        this.accountIdsWithNewAuth = accountIdsWithNewAuth;
        return this;
    }

    public AuthDefaultUpdateWebhook addAccountIdsWithNewAuthItem(String accountIdsWithNewAuthItem) {
        this.accountIdsWithNewAuth.add(accountIdsWithNewAuthItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of `account_id`'s for accounts that contain new auth.'")
    public List<String> getAccountIdsWithNewAuth() {
        return this.accountIdsWithNewAuth;
    }

    public void setAccountIdsWithNewAuth(List<String> accountIdsWithNewAuth) {
        this.accountIdsWithNewAuth = accountIdsWithNewAuth;
    }

    public AuthDefaultUpdateWebhook accountIdsWithUpdatedAuth(Map<String, List<AuthUpdateTypes>> accountIdsWithUpdatedAuth) {
        this.accountIdsWithUpdatedAuth = accountIdsWithUpdatedAuth;
        return this;
    }

    public AuthDefaultUpdateWebhook putAccountIdsWithUpdatedAuthItem(String key, List<AuthUpdateTypes> accountIdsWithUpdatedAuthItem) {
        this.accountIdsWithUpdatedAuth.put(key, accountIdsWithUpdatedAuthItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An object with keys of `account_id`'s that are mapped to their respective auth attributes that changed.  Example: `{ \"XMBvvyMGQ1UoLbKByoMqH3nXMj84ALSdE5B58\": [\"ACCOUNT_NUMBER\"] }` ")
    public Map<String, List<AuthUpdateTypes>> getAccountIdsWithUpdatedAuth() {
        return this.accountIdsWithUpdatedAuth;
    }

    public void setAccountIdsWithUpdatedAuth(Map<String, List<AuthUpdateTypes>> accountIdsWithUpdatedAuth) {
        this.accountIdsWithUpdatedAuth = accountIdsWithUpdatedAuth;
    }

    public AuthDefaultUpdateWebhook error(PlaidError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public PlaidError getError() {
        return this.error;
    }

    public void setError(PlaidError error) {
        this.error = error;
    }

    public AuthDefaultUpdateWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthDefaultUpdateWebhook authDefaultUpdateWebhook = (AuthDefaultUpdateWebhook)o;
        return Objects.equals(this.webhookType, authDefaultUpdateWebhook.webhookType) && Objects.equals(this.webhookCode, authDefaultUpdateWebhook.webhookCode) && Objects.equals(this.itemId, authDefaultUpdateWebhook.itemId) && Objects.equals(this.accountIdsWithNewAuth, authDefaultUpdateWebhook.accountIdsWithNewAuth) && Objects.equals(this.accountIdsWithUpdatedAuth, authDefaultUpdateWebhook.accountIdsWithUpdatedAuth) && Objects.equals(this.error, authDefaultUpdateWebhook.error) && Objects.equals((Object)this.environment, (Object)authDefaultUpdateWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.itemId, this.accountIdsWithNewAuth, this.accountIdsWithUpdatedAuth, this.error, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthDefaultUpdateWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    accountIdsWithNewAuth: ").append(this.toIndentedString(this.accountIdsWithNewAuth)).append("\n");
        sb.append("    accountIdsWithUpdatedAuth: ").append(this.toIndentedString(this.accountIdsWithUpdatedAuth)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

