/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.NumbersACH;
import com.plaid.client.model.NumbersBACS;
import com.plaid.client.model.NumbersEFT;
import com.plaid.client.model.NumbersInternational;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="An object containing identifying numbers used for making electronic transfers to and from the `accounts`. The identifying number type (ACH, EFT, IBAN, or BACS) used will depend on the country of the account. An account may have more than one number type. If a particular identifying number type is not used by any `accounts` for which data has been requested, the array for that type will be empty.")
public class AuthGetNumbers {
    public static final String SERIALIZED_NAME_ACH = "ach";
    @SerializedName(value="ach")
    private List<NumbersACH> ach = new ArrayList<NumbersACH>();
    public static final String SERIALIZED_NAME_EFT = "eft";
    @SerializedName(value="eft")
    private List<NumbersEFT> eft = new ArrayList<NumbersEFT>();
    public static final String SERIALIZED_NAME_INTERNATIONAL = "international";
    @SerializedName(value="international")
    private List<NumbersInternational> international = new ArrayList<NumbersInternational>();
    public static final String SERIALIZED_NAME_BACS = "bacs";
    @SerializedName(value="bacs")
    private List<NumbersBACS> bacs = new ArrayList<NumbersBACS>();

    public AuthGetNumbers ach(List<NumbersACH> ach) {
        this.ach = ach;
        return this;
    }

    public AuthGetNumbers addAchItem(NumbersACH achItem) {
        this.ach.add(achItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of ACH numbers identifying accounts.")
    public List<NumbersACH> getAch() {
        return this.ach;
    }

    public void setAch(List<NumbersACH> ach) {
        this.ach = ach;
    }

    public AuthGetNumbers eft(List<NumbersEFT> eft) {
        this.eft = eft;
        return this;
    }

    public AuthGetNumbers addEftItem(NumbersEFT eftItem) {
        this.eft.add(eftItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of EFT numbers identifying accounts.")
    public List<NumbersEFT> getEft() {
        return this.eft;
    }

    public void setEft(List<NumbersEFT> eft) {
        this.eft = eft;
    }

    public AuthGetNumbers international(List<NumbersInternational> international) {
        this.international = international;
        return this;
    }

    public AuthGetNumbers addInternationalItem(NumbersInternational internationalItem) {
        this.international.add(internationalItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of IBAN numbers identifying accounts.")
    public List<NumbersInternational> getInternational() {
        return this.international;
    }

    public void setInternational(List<NumbersInternational> international) {
        this.international = international;
    }

    public AuthGetNumbers bacs(List<NumbersBACS> bacs) {
        this.bacs = bacs;
        return this;
    }

    public AuthGetNumbers addBacsItem(NumbersBACS bacsItem) {
        this.bacs.add(bacsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of BACS numbers identifying accounts.")
    public List<NumbersBACS> getBacs() {
        return this.bacs;
    }

    public void setBacs(List<NumbersBACS> bacs) {
        this.bacs = bacs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthGetNumbers authGetNumbers = (AuthGetNumbers)o;
        return Objects.equals(this.ach, authGetNumbers.ach) && Objects.equals(this.eft, authGetNumbers.eft) && Objects.equals(this.international, authGetNumbers.international) && Objects.equals(this.bacs, authGetNumbers.bacs);
    }

    public int hashCode() {
        return Objects.hash(this.ach, this.eft, this.international, this.bacs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthGetNumbers {\n");
        sb.append("    ach: ").append(this.toIndentedString(this.ach)).append("\n");
        sb.append("    eft: ").append(this.toIndentedString(this.eft)).append("\n");
        sb.append("    international: ").append(this.toIndentedString(this.international)).append("\n");
        sb.append("    bacs: ").append(this.toIndentedString(this.bacs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

