/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountBase;
import com.plaid.client.model.AuthGetNumbers;
import com.plaid.client.model.Item;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="AuthGetResponse defines the response schema for `/auth/get`")
public class AuthGetResponse {
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<AccountBase> accounts = new ArrayList<AccountBase>();
    public static final String SERIALIZED_NAME_NUMBERS = "numbers";
    @SerializedName(value="numbers")
    private AuthGetNumbers numbers;
    public static final String SERIALIZED_NAME_ITEM = "item";
    @SerializedName(value="item")
    private Item item;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public AuthGetResponse accounts(List<AccountBase> accounts) {
        this.accounts = accounts;
        return this;
    }

    public AuthGetResponse addAccountsItem(AccountBase accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The `accounts` for which numbers are being retrieved.")
    public List<AccountBase> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AccountBase> accounts) {
        this.accounts = accounts;
    }

    public AuthGetResponse numbers(AuthGetNumbers numbers) {
        this.numbers = numbers;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AuthGetNumbers getNumbers() {
        return this.numbers;
    }

    public void setNumbers(AuthGetNumbers numbers) {
        this.numbers = numbers;
    }

    public AuthGetResponse item(Item item) {
        this.item = item;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public AuthGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthGetResponse authGetResponse = (AuthGetResponse)o;
        return Objects.equals(this.accounts, authGetResponse.accounts) && Objects.equals(this.numbers, authGetResponse.numbers) && Objects.equals(this.item, authGetResponse.item) && Objects.equals(this.requestId, authGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.accounts, this.numbers, this.item, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthGetResponse {\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    numbers: ").append(this.toIndentedString(this.numbers)).append("\n");
        sb.append("    item: ").append(this.toIndentedString(this.item)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

