/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Metadata specifically related to which auth methods an institution supports.")
public class AuthSupportedMethods {
    public static final String SERIALIZED_NAME_INSTANT_AUTH = "instant_auth";
    @SerializedName(value="instant_auth")
    private Boolean instantAuth;
    public static final String SERIALIZED_NAME_INSTANT_MATCH = "instant_match";
    @SerializedName(value="instant_match")
    private Boolean instantMatch;
    public static final String SERIALIZED_NAME_AUTOMATED_MICRO_DEPOSITS = "automated_micro_deposits";
    @SerializedName(value="automated_micro_deposits")
    private Boolean automatedMicroDeposits;
    public static final String SERIALIZED_NAME_INSTANT_MICRO_DEPOSITS = "instant_micro_deposits";
    @SerializedName(value="instant_micro_deposits")
    private Boolean instantMicroDeposits;

    public AuthSupportedMethods instantAuth(Boolean instantAuth) {
        this.instantAuth = instantAuth;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if instant auth is supported.")
    public Boolean getInstantAuth() {
        return this.instantAuth;
    }

    public void setInstantAuth(Boolean instantAuth) {
        this.instantAuth = instantAuth;
    }

    public AuthSupportedMethods instantMatch(Boolean instantMatch) {
        this.instantMatch = instantMatch;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if instant match is supported.")
    public Boolean getInstantMatch() {
        return this.instantMatch;
    }

    public void setInstantMatch(Boolean instantMatch) {
        this.instantMatch = instantMatch;
    }

    public AuthSupportedMethods automatedMicroDeposits(Boolean automatedMicroDeposits) {
        this.automatedMicroDeposits = automatedMicroDeposits;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if automated microdeposits are supported.")
    public Boolean getAutomatedMicroDeposits() {
        return this.automatedMicroDeposits;
    }

    public void setAutomatedMicroDeposits(Boolean automatedMicroDeposits) {
        this.automatedMicroDeposits = automatedMicroDeposits;
    }

    public AuthSupportedMethods instantMicroDeposits(Boolean instantMicroDeposits) {
        this.instantMicroDeposits = instantMicroDeposits;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if instant microdeposits are supported.")
    public Boolean getInstantMicroDeposits() {
        return this.instantMicroDeposits;
    }

    public void setInstantMicroDeposits(Boolean instantMicroDeposits) {
        this.instantMicroDeposits = instantMicroDeposits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthSupportedMethods authSupportedMethods = (AuthSupportedMethods)o;
        return Objects.equals(this.instantAuth, authSupportedMethods.instantAuth) && Objects.equals(this.instantMatch, authSupportedMethods.instantMatch) && Objects.equals(this.automatedMicroDeposits, authSupportedMethods.automatedMicroDeposits) && Objects.equals(this.instantMicroDeposits, authSupportedMethods.instantMicroDeposits);
    }

    public int hashCode() {
        return Objects.hash(this.instantAuth, this.instantMatch, this.automatedMicroDeposits, this.instantMicroDeposits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthSupportedMethods {\n");
        sb.append("    instantAuth: ").append(this.toIndentedString(this.instantAuth)).append("\n");
        sb.append("    instantMatch: ").append(this.toIndentedString(this.instantMatch)).append("\n");
        sb.append("    automatedMicroDeposits: ").append(this.toIndentedString(this.automatedMicroDeposits)).append("\n");
        sb.append("    instantMicroDeposits: ").append(this.toIndentedString(this.instantMicroDeposits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

