/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BankIncomeCompleteResult;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Fired when a bank income report has finished generating or failed to generate, triggered by calling `/credit/bank_income/get` in CRA enabled client.")
public class BankIncomeCompleteWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(value="user_id")
    private String userId;
    public static final String SERIALIZED_NAME_RESULT = "result";
    @SerializedName(value="result")
    private BankIncomeCompleteResult result;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public BankIncomeCompleteWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`INCOME`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public BankIncomeCompleteWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`BANK_INCOME_COMPLETE`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public BankIncomeCompleteWebhook userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `user_id` corresponding to the user the webhook has fired for.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public BankIncomeCompleteWebhook result(BankIncomeCompleteResult result) {
        this.result = result;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BankIncomeCompleteResult getResult() {
        return this.result;
    }

    public void setResult(BankIncomeCompleteResult result) {
        this.result = result;
    }

    public BankIncomeCompleteWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankIncomeCompleteWebhook bankIncomeCompleteWebhook = (BankIncomeCompleteWebhook)o;
        return Objects.equals(this.webhookType, bankIncomeCompleteWebhook.webhookType) && Objects.equals(this.webhookCode, bankIncomeCompleteWebhook.webhookCode) && Objects.equals(this.userId, bankIncomeCompleteWebhook.userId) && Objects.equals((Object)this.result, (Object)bankIncomeCompleteWebhook.result) && Objects.equals((Object)this.environment, (Object)bankIncomeCompleteWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.userId, this.result, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankIncomeCompleteWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    result: ").append(this.toIndentedString((Object)this.result)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

