/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The object contains a risk score and a risk tier that evaluate the transaction return risk because an account is overdrawn or because an ineligible account is used. Common return codes in this category include: \"R01\", \"R02\", \"R03\", \"R04\", \"R06\", \"R08\",  \"R09\", \"R13\", \"R16\", \"R17\", \"R20\", \"R23\". These returns have a turnaround time of 2 banking days.")
public class BankInitiatedReturnRisk {
    public static final String SERIALIZED_NAME_SCORE = "score";
    @SerializedName(value="score")
    private Integer score;
    public static final String SERIALIZED_NAME_RISK_TIER = "risk_tier";
    @SerializedName(value="risk_tier")
    private Integer riskTier;

    public BankInitiatedReturnRisk score(Integer score) {
        this.score = score;
        return this;
    }

    @ApiModelProperty(required=true, value="A score from 1-99 that indicates the transaction return risk: a higher risk score suggests a higher return likelihood.")
    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public BankInitiatedReturnRisk riskTier(Integer riskTier) {
        this.riskTier = riskTier;
        return this;
    }

    @ApiModelProperty(required=true, value="In the `bank_initiated_return_risk` object, there are eight risk tiers corresponding to the scores:   1: Predicted bank-initiated return incidence rate between 0.0% - 0.5%   2: Predicted bank-initiated return incidence rate between 0.5% - 1.5%   3: Predicted bank-initiated return incidence rate between 1.5% - 3%   4: Predicted bank-initiated return incidence rate between 3% - 5%   5: Predicted bank-initiated return incidence rate between 5% - 10%   6: Predicted bank-initiated return incidence rate between 10% - 15%   7: Predicted bank-initiated return incidence rate between 15% and 50%   8: Predicted bank-initiated return incidence rate greater than 50% ")
    public Integer getRiskTier() {
        return this.riskTier;
    }

    public void setRiskTier(Integer riskTier) {
        this.riskTier = riskTier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankInitiatedReturnRisk bankInitiatedReturnRisk = (BankInitiatedReturnRisk)o;
        return Objects.equals(this.score, bankInitiatedReturnRisk.score) && Objects.equals(this.riskTier, bankInitiatedReturnRisk.riskTier);
    }

    public int hashCode() {
        return Objects.hash(this.score, this.riskTier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankInitiatedReturnRisk {\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    riskTier: ").append(this.toIndentedString(this.riskTier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

