/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ACHClass;
import com.plaid.client.model.BankTransferDirection;
import com.plaid.client.model.BankTransferFailure;
import com.plaid.client.model.BankTransferNetwork;
import com.plaid.client.model.BankTransferStatus;
import com.plaid.client.model.BankTransferType;
import com.plaid.client.model.BankTransferUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a bank transfer within the Bank Transfers API.")
public class BankTransfer {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ACH_CLASS = "ach_class";
    @SerializedName(value="ach_class")
    private ACHClass achClass;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private BankTransferType type;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private BankTransferUser user;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private BankTransferStatus status;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private BankTransferNetwork network;
    public static final String SERIALIZED_NAME_CANCELLABLE = "cancellable";
    @SerializedName(value="cancellable")
    private Boolean cancellable;
    public static final String SERIALIZED_NAME_FAILURE_REASON = "failure_reason";
    @SerializedName(value="failure_reason")
    private BankTransferFailure failureReason;
    public static final String SERIALIZED_NAME_CUSTOM_TAG = "custom_tag";
    @SerializedName(value="custom_tag")
    private String customTag;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private BankTransferDirection direction;

    public BankTransfer id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a bank transfer.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BankTransfer achClass(ACHClass achClass) {
        this.achClass = achClass;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ACHClass getAchClass() {
        return this.achClass;
    }

    public void setAchClass(ACHClass achClass) {
        this.achClass = achClass;
    }

    public BankTransfer accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The account ID that should be credited/debited for this bank transfer.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BankTransfer type(BankTransferType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BankTransferType getType() {
        return this.type;
    }

    public void setType(BankTransferType type) {
        this.type = type;
    }

    public BankTransfer user(BankTransferUser user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BankTransferUser getUser() {
        return this.user;
    }

    public void setUser(BankTransferUser user) {
        this.user = user;
    }

    public BankTransfer amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of the bank transfer (decimal string with two digits of precision e.g. \"10.00\").")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public BankTransfer isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency of the transfer amount, e.g. \"USD\"")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public BankTransfer description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The description of the transfer.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BankTransfer created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(required=true, value="The datetime when this bank transfer was created. This will be of the form `2006-01-02T15:04:05Z`")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public BankTransfer status(BankTransferStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BankTransferStatus getStatus() {
        return this.status;
    }

    public void setStatus(BankTransferStatus status) {
        this.status = status;
    }

    public BankTransfer network(BankTransferNetwork network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BankTransferNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(BankTransferNetwork network) {
        this.network = network;
    }

    public BankTransfer cancellable(Boolean cancellable) {
        this.cancellable = cancellable;
        return this;
    }

    @ApiModelProperty(required=true, value="When `true`, you can still cancel this bank transfer.")
    public Boolean getCancellable() {
        return this.cancellable;
    }

    public void setCancellable(Boolean cancellable) {
        this.cancellable = cancellable;
    }

    public BankTransfer failureReason(BankTransferFailure failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public BankTransferFailure getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(BankTransferFailure failureReason) {
        this.failureReason = failureReason;
    }

    public BankTransfer customTag(String customTag) {
        this.customTag = customTag;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A string containing the custom tag provided by the client in the create request. Will be null if not provided.")
    public String getCustomTag() {
        return this.customTag;
    }

    public void setCustomTag(String customTag) {
        this.customTag = customTag;
    }

    public BankTransfer metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BankTransfer putMetadataItem(String key, String metadataItem) {
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: The JSON values must be Strings (no nested JSON objects allowed) Only ASCII characters may be used Maximum of 50 key/value pairs Maximum key length of 40 characters Maximum value length of 500 characters ")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public BankTransfer originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for the origination account that was used for this transfer.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public BankTransfer direction(BankTransferDirection direction) {
        this.direction = direction;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public BankTransferDirection getDirection() {
        return this.direction;
    }

    public void setDirection(BankTransferDirection direction) {
        this.direction = direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransfer bankTransfer = (BankTransfer)o;
        return Objects.equals(this.id, bankTransfer.id) && Objects.equals((Object)this.achClass, (Object)bankTransfer.achClass) && Objects.equals(this.accountId, bankTransfer.accountId) && Objects.equals((Object)this.type, (Object)bankTransfer.type) && Objects.equals(this.user, bankTransfer.user) && Objects.equals(this.amount, bankTransfer.amount) && Objects.equals(this.isoCurrencyCode, bankTransfer.isoCurrencyCode) && Objects.equals(this.description, bankTransfer.description) && Objects.equals(this.created, bankTransfer.created) && Objects.equals((Object)this.status, (Object)bankTransfer.status) && Objects.equals((Object)this.network, (Object)bankTransfer.network) && Objects.equals(this.cancellable, bankTransfer.cancellable) && Objects.equals(this.failureReason, bankTransfer.failureReason) && Objects.equals(this.customTag, bankTransfer.customTag) && Objects.equals(this.metadata, bankTransfer.metadata) && Objects.equals(this.originationAccountId, bankTransfer.originationAccountId) && Objects.equals((Object)this.direction, (Object)bankTransfer.direction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.achClass, this.accountId, this.type, this.user, this.amount, this.isoCurrencyCode, this.description, this.created, this.status, this.network, this.cancellable, this.failureReason, this.customTag, this.metadata, this.originationAccountId, this.direction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransfer {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    achClass: ").append(this.toIndentedString((Object)this.achClass)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    cancellable: ").append(this.toIndentedString(this.cancellable)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    customTag: ").append(this.toIndentedString(this.customTag)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

