/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information about the balance of a bank transfer")
public class BankTransferBalance {
    public static final String SERIALIZED_NAME_AVAILABLE = "available";
    @SerializedName(value="available")
    private String available;
    public static final String SERIALIZED_NAME_TRANSACTABLE = "transactable";
    @SerializedName(value="transactable")
    private String transactable;

    public BankTransferBalance available(String available) {
        this.available = available;
        return this;
    }

    @ApiModelProperty(required=true, value="The total available balance - the sum of all successful debit transfer amounts minus all credit transfer amounts.")
    public String getAvailable() {
        return this.available;
    }

    public void setAvailable(String available) {
        this.available = available;
    }

    public BankTransferBalance transactable(String transactable) {
        this.transactable = transactable;
        return this;
    }

    @ApiModelProperty(required=true, value="The transactable balance shows the amount in your account that you are able to use for transfers, and is essentially your available balance minus your minimum balance.")
    public String getTransactable() {
        return this.transactable;
    }

    public void setTransactable(String transactable) {
        this.transactable = transactable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransferBalance bankTransferBalance = (BankTransferBalance)o;
        return Objects.equals(this.available, bankTransferBalance.available) && Objects.equals(this.transactable, bankTransferBalance.transactable);
    }

    public int hashCode() {
        return Objects.hash(this.available, this.transactable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransferBalance {\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    transactable: ").append(this.toIndentedString(this.transactable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

