/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/bank_transfer/balance/get`")
public class BankTransferBalanceGetRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;

    public BankTransferBalanceGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public BankTransferBalanceGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public BankTransferBalanceGetRequest originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If multiple origination accounts are available, `origination_account_id` must be used to specify the account for which balance will be returned.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransferBalanceGetRequest bankTransferBalanceGetRequest = (BankTransferBalanceGetRequest)o;
        return Objects.equals(this.clientId, bankTransferBalanceGetRequest.clientId) && Objects.equals(this.secret, bankTransferBalanceGetRequest.secret) && Objects.equals(this.originationAccountId, bankTransferBalanceGetRequest.originationAccountId);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.originationAccountId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransferBalanceGetRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

