/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BankTransferDirection;
import com.plaid.client.model.BankTransferEventType;
import com.plaid.client.model.BankTransferFailure;
import com.plaid.client.model.BankTransferType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents an event in the Bank Transfers API.")
public class BankTransferEvent {
    public static final String SERIALIZED_NAME_EVENT_ID = "event_id";
    @SerializedName(value="event_id")
    private Integer eventId;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private OffsetDateTime timestamp;
    public static final String SERIALIZED_NAME_EVENT_TYPE = "event_type";
    @SerializedName(value="event_type")
    private BankTransferEventType eventType;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_BANK_TRANSFER_ID = "bank_transfer_id";
    @SerializedName(value="bank_transfer_id")
    private String bankTransferId;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_BANK_TRANSFER_TYPE = "bank_transfer_type";
    @SerializedName(value="bank_transfer_type")
    private BankTransferType bankTransferType;
    public static final String SERIALIZED_NAME_BANK_TRANSFER_AMOUNT = "bank_transfer_amount";
    @SerializedName(value="bank_transfer_amount")
    private String bankTransferAmount;
    public static final String SERIALIZED_NAME_BANK_TRANSFER_ISO_CURRENCY_CODE = "bank_transfer_iso_currency_code";
    @SerializedName(value="bank_transfer_iso_currency_code")
    private String bankTransferIsoCurrencyCode;
    public static final String SERIALIZED_NAME_FAILURE_REASON = "failure_reason";
    @SerializedName(value="failure_reason")
    private BankTransferFailure failureReason;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private BankTransferDirection direction;

    public BankTransferEvent eventId(Integer eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for this event. IDs are sequential unsigned 64-bit integers.")
    public Integer getEventId() {
        return this.eventId;
    }

    public void setEventId(Integer eventId) {
        this.eventId = eventId;
    }

    public BankTransferEvent timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="The datetime when this event occurred. This will be of the form `2006-01-02T15:04:05Z`.")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public BankTransferEvent eventType(BankTransferEventType eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BankTransferEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(BankTransferEventType eventType) {
        this.eventType = eventType;
    }

    public BankTransferEvent accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The account ID associated with the bank transfer.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BankTransferEvent bankTransferId(String bankTransferId) {
        this.bankTransferId = bankTransferId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a bank transfer.")
    public String getBankTransferId() {
        return this.bankTransferId;
    }

    public void setBankTransferId(String bankTransferId) {
        this.bankTransferId = bankTransferId;
    }

    public BankTransferEvent originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ID of the origination account that this balance belongs to.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public BankTransferEvent bankTransferType(BankTransferType bankTransferType) {
        this.bankTransferType = bankTransferType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BankTransferType getBankTransferType() {
        return this.bankTransferType;
    }

    public void setBankTransferType(BankTransferType bankTransferType) {
        this.bankTransferType = bankTransferType;
    }

    public BankTransferEvent bankTransferAmount(String bankTransferAmount) {
        this.bankTransferAmount = bankTransferAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The bank transfer amount.")
    public String getBankTransferAmount() {
        return this.bankTransferAmount;
    }

    public void setBankTransferAmount(String bankTransferAmount) {
        this.bankTransferAmount = bankTransferAmount;
    }

    public BankTransferEvent bankTransferIsoCurrencyCode(String bankTransferIsoCurrencyCode) {
        this.bankTransferIsoCurrencyCode = bankTransferIsoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency of the bank transfer amount.")
    public String getBankTransferIsoCurrencyCode() {
        return this.bankTransferIsoCurrencyCode;
    }

    public void setBankTransferIsoCurrencyCode(String bankTransferIsoCurrencyCode) {
        this.bankTransferIsoCurrencyCode = bankTransferIsoCurrencyCode;
    }

    public BankTransferEvent failureReason(BankTransferFailure failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public BankTransferFailure getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(BankTransferFailure failureReason) {
        this.failureReason = failureReason;
    }

    public BankTransferEvent direction(BankTransferDirection direction) {
        this.direction = direction;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public BankTransferDirection getDirection() {
        return this.direction;
    }

    public void setDirection(BankTransferDirection direction) {
        this.direction = direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransferEvent bankTransferEvent = (BankTransferEvent)o;
        return Objects.equals(this.eventId, bankTransferEvent.eventId) && Objects.equals(this.timestamp, bankTransferEvent.timestamp) && Objects.equals((Object)this.eventType, (Object)bankTransferEvent.eventType) && Objects.equals(this.accountId, bankTransferEvent.accountId) && Objects.equals(this.bankTransferId, bankTransferEvent.bankTransferId) && Objects.equals(this.originationAccountId, bankTransferEvent.originationAccountId) && Objects.equals((Object)this.bankTransferType, (Object)bankTransferEvent.bankTransferType) && Objects.equals(this.bankTransferAmount, bankTransferEvent.bankTransferAmount) && Objects.equals(this.bankTransferIsoCurrencyCode, bankTransferEvent.bankTransferIsoCurrencyCode) && Objects.equals(this.failureReason, bankTransferEvent.failureReason) && Objects.equals((Object)this.direction, (Object)bankTransferEvent.direction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventId, this.timestamp, this.eventType, this.accountId, this.bankTransferId, this.originationAccountId, this.bankTransferType, this.bankTransferAmount, this.bankTransferIsoCurrencyCode, this.failureReason, this.direction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransferEvent {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    bankTransferId: ").append(this.toIndentedString(this.bankTransferId)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    bankTransferType: ").append(this.toIndentedString((Object)this.bankTransferType)).append("\n");
        sb.append("    bankTransferAmount: ").append(this.toIndentedString(this.bankTransferAmount)).append("\n");
        sb.append("    bankTransferIsoCurrencyCode: ").append(this.toIndentedString(this.bankTransferIsoCurrencyCode)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

