/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BankTransferEventListBankTransferType;
import com.plaid.client.model.BankTransferEventListDirection;
import com.plaid.client.model.BankTransferEventType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/bank_transfer/event/list`")
public class BankTransferEventListRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private OffsetDateTime startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private OffsetDateTime endDate;
    public static final String SERIALIZED_NAME_BANK_TRANSFER_ID = "bank_transfer_id";
    @SerializedName(value="bank_transfer_id")
    private String bankTransferId;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_BANK_TRANSFER_TYPE = "bank_transfer_type";
    @SerializedName(value="bank_transfer_type")
    private BankTransferEventListBankTransferType bankTransferType;
    public static final String SERIALIZED_NAME_EVENT_TYPES = "event_types";
    @SerializedName(value="event_types")
    private List<BankTransferEventType> eventTypes = null;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count = 25;
    public static final String SERIALIZED_NAME_OFFSET = "offset";
    @SerializedName(value="offset")
    private Integer offset = 0;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private BankTransferEventListDirection direction;

    public BankTransferEventListRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public BankTransferEventListRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public BankTransferEventListRequest startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The start datetime of bank transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public BankTransferEventListRequest endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end datetime of bank transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public BankTransferEventListRequest bankTransferId(String bankTransferId) {
        this.bankTransferId = bankTransferId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid\u2019s unique identifier for a bank transfer.")
    public String getBankTransferId() {
        return this.bankTransferId;
    }

    public void setBankTransferId(String bankTransferId) {
        this.bankTransferId = bankTransferId;
    }

    public BankTransferEventListRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account ID to get events for all transactions to/from an account.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BankTransferEventListRequest bankTransferType(BankTransferEventListBankTransferType bankTransferType) {
        this.bankTransferType = bankTransferType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BankTransferEventListBankTransferType getBankTransferType() {
        return this.bankTransferType;
    }

    public void setBankTransferType(BankTransferEventListBankTransferType bankTransferType) {
        this.bankTransferType = bankTransferType;
    }

    public BankTransferEventListRequest eventTypes(List<BankTransferEventType> eventTypes) {
        this.eventTypes = eventTypes;
        return this;
    }

    public BankTransferEventListRequest addEventTypesItem(BankTransferEventType eventTypesItem) {
        if (this.eventTypes == null) {
            this.eventTypes = new ArrayList<BankTransferEventType>();
        }
        this.eventTypes.add(eventTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter events by event type.")
    public List<BankTransferEventType> getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(List<BankTransferEventType> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public BankTransferEventListRequest count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of bank transfer events to return. If the number of events matching the above parameters is greater than `count`, the most recent events will be returned.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public BankTransferEventListRequest offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The offset into the list of bank transfer events. When `count`=25 and `offset`=0, the first 25 events will be returned. When `count`=25 and `offset`=25, the next 25 bank transfer events will be returned.")
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public BankTransferEventListRequest originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The origination account ID to get events for transfers from a specific origination account.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public BankTransferEventListRequest direction(BankTransferEventListDirection direction) {
        this.direction = direction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BankTransferEventListDirection getDirection() {
        return this.direction;
    }

    public void setDirection(BankTransferEventListDirection direction) {
        this.direction = direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransferEventListRequest bankTransferEventListRequest = (BankTransferEventListRequest)o;
        return Objects.equals(this.clientId, bankTransferEventListRequest.clientId) && Objects.equals(this.secret, bankTransferEventListRequest.secret) && Objects.equals(this.startDate, bankTransferEventListRequest.startDate) && Objects.equals(this.endDate, bankTransferEventListRequest.endDate) && Objects.equals(this.bankTransferId, bankTransferEventListRequest.bankTransferId) && Objects.equals(this.accountId, bankTransferEventListRequest.accountId) && Objects.equals((Object)this.bankTransferType, (Object)bankTransferEventListRequest.bankTransferType) && Objects.equals(this.eventTypes, bankTransferEventListRequest.eventTypes) && Objects.equals(this.count, bankTransferEventListRequest.count) && Objects.equals(this.offset, bankTransferEventListRequest.offset) && Objects.equals(this.originationAccountId, bankTransferEventListRequest.originationAccountId) && Objects.equals((Object)this.direction, (Object)bankTransferEventListRequest.direction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.startDate, this.endDate, this.bankTransferId, this.accountId, this.bankTransferType, this.eventTypes, this.count, this.offset, this.originationAccountId, this.direction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransferEventListRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    bankTransferId: ").append(this.toIndentedString(this.bankTransferId)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    bankTransferType: ").append(this.toIndentedString((Object)this.bankTransferType)).append("\n");
        sb.append("    eventTypes: ").append(this.toIndentedString(this.eventTypes)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

