/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/bank_transfer/event/sync`")
public class BankTransferEventSyncRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_AFTER_ID = "after_id";
    @SerializedName(value="after_id")
    private Integer afterId;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count = 25;

    public BankTransferEventSyncRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public BankTransferEventSyncRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public BankTransferEventSyncRequest afterId(Integer afterId) {
        this.afterId = afterId;
        return this;
    }

    @ApiModelProperty(required=true, value="The latest (largest) `event_id` fetched via the sync endpoint, or 0 initially.")
    public Integer getAfterId() {
        return this.afterId;
    }

    public void setAfterId(Integer afterId) {
        this.afterId = afterId;
    }

    public BankTransferEventSyncRequest count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of bank transfer events to return.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransferEventSyncRequest bankTransferEventSyncRequest = (BankTransferEventSyncRequest)o;
        return Objects.equals(this.clientId, bankTransferEventSyncRequest.clientId) && Objects.equals(this.secret, bankTransferEventSyncRequest.secret) && Objects.equals(this.afterId, bankTransferEventSyncRequest.afterId) && Objects.equals(this.count, bankTransferEventSyncRequest.count);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.afterId, this.count);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransferEventSyncRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    afterId: ").append(this.toIndentedString(this.afterId)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

