/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The failure reason if the type of this transfer is `\"failed\"` or `\"reversed\"`. Null value otherwise.")
public class BankTransferFailure {
    public static final String SERIALIZED_NAME_ACH_RETURN_CODE = "ach_return_code";
    @SerializedName(value="ach_return_code")
    private String achReturnCode;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;

    public BankTransferFailure achReturnCode(String achReturnCode) {
        this.achReturnCode = achReturnCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ACH return code, e.g. `R01`.  A return code will be provided if and only if the transfer status is `reversed`. For a full listing of ACH return codes, see [Bank Transfers errors](https://plaid.com/docs/errors/bank-transfers/#ach-return-codes).")
    public String getAchReturnCode() {
        return this.achReturnCode;
    }

    public void setAchReturnCode(String achReturnCode) {
        this.achReturnCode = achReturnCode;
    }

    public BankTransferFailure description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A human-readable description of the reason for the failure or reversal.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransferFailure bankTransferFailure = (BankTransferFailure)o;
        return Objects.equals(this.achReturnCode, bankTransferFailure.achReturnCode) && Objects.equals(this.description, bankTransferFailure.description);
    }

    public int hashCode() {
        return Objects.hash(this.achReturnCode, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransferFailure {\n");
        sb.append("    achReturnCode: ").append(this.toIndentedString(this.achReturnCode)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

