/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/bank_transfer/migrate_account`")
public class BankTransferMigrateAccountRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_ROUTING_NUMBER = "routing_number";
    @SerializedName(value="routing_number")
    private String routingNumber;
    public static final String SERIALIZED_NAME_WIRE_ROUTING_NUMBER = "wire_routing_number";
    @SerializedName(value="wire_routing_number")
    private String wireRoutingNumber;
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "account_type";
    @SerializedName(value="account_type")
    private String accountType;

    public BankTransferMigrateAccountRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public BankTransferMigrateAccountRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public BankTransferMigrateAccountRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The user's account number.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public BankTransferMigrateAccountRequest routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The user's routing number.")
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public BankTransferMigrateAccountRequest wireRoutingNumber(String wireRoutingNumber) {
        this.wireRoutingNumber = wireRoutingNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's wire transfer routing number. This is the ABA number; for some institutions, this may differ from the ACH number used in `routing_number`.")
    public String getWireRoutingNumber() {
        return this.wireRoutingNumber;
    }

    public void setWireRoutingNumber(String wireRoutingNumber) {
        this.wireRoutingNumber = wireRoutingNumber;
    }

    public BankTransferMigrateAccountRequest accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the bank account (`checking` or `savings`).")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransferMigrateAccountRequest bankTransferMigrateAccountRequest = (BankTransferMigrateAccountRequest)o;
        return Objects.equals(this.clientId, bankTransferMigrateAccountRequest.clientId) && Objects.equals(this.secret, bankTransferMigrateAccountRequest.secret) && Objects.equals(this.accountNumber, bankTransferMigrateAccountRequest.accountNumber) && Objects.equals(this.routingNumber, bankTransferMigrateAccountRequest.routingNumber) && Objects.equals(this.wireRoutingNumber, bankTransferMigrateAccountRequest.wireRoutingNumber) && Objects.equals(this.accountType, bankTransferMigrateAccountRequest.accountType);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.accountNumber, this.routingNumber, this.wireRoutingNumber, this.accountType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransferMigrateAccountRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    wireRoutingNumber: ").append(this.toIndentedString(this.wireRoutingNumber)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

