/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="BankTransferSweepListRequest defines the request schema for `/bank_transfer/sweep/list`")
public class BankTransferSweepListRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_START_TIME = "start_time";
    @SerializedName(value="start_time")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_END_TIME = "end_time";
    @SerializedName(value="end_time")
    private OffsetDateTime endTime;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count = 25;

    public BankTransferSweepListRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public BankTransferSweepListRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public BankTransferSweepListRequest originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If multiple origination accounts are available, `origination_account_id` must be used to specify the account that the sweeps belong to.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public BankTransferSweepListRequest startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The start datetime of sweeps to return (RFC 3339 format).")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public BankTransferSweepListRequest endTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end datetime of sweeps to return (RFC 3339 format).")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public BankTransferSweepListRequest count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of sweeps to return.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransferSweepListRequest bankTransferSweepListRequest = (BankTransferSweepListRequest)o;
        return Objects.equals(this.clientId, bankTransferSweepListRequest.clientId) && Objects.equals(this.secret, bankTransferSweepListRequest.secret) && Objects.equals(this.originationAccountId, bankTransferSweepListRequest.originationAccountId) && Objects.equals(this.startTime, bankTransferSweepListRequest.startTime) && Objects.equals(this.endTime, bankTransferSweepListRequest.endTime) && Objects.equals(this.count, bankTransferSweepListRequest.count);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.originationAccountId, this.startTime, this.endTime, this.count);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransferSweepListRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

