/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The legal name and other information for the account holder.")
public class BankTransferUser {
    public static final String SERIALIZED_NAME_LEGAL_NAME = "legal_name";
    @SerializedName(value="legal_name")
    private String legalName;
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "email_address";
    @SerializedName(value="email_address")
    private String emailAddress;
    public static final String SERIALIZED_NAME_ROUTING_NUMBER = "routing_number";
    @SerializedName(value="routing_number")
    private String routingNumber;

    public BankTransferUser legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @ApiModelProperty(required=true, value="The account holder\u2019s full legal name. If the transfer `ach_class` is `ccd`, this should be the business name of the account holder.")
    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public BankTransferUser emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account holder\u2019s email.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Nullable
    @ApiModelProperty(value="The account holder's routing number. This field is only used in response data. Do not provide this field when making requests.")
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransferUser bankTransferUser = (BankTransferUser)o;
        return Objects.equals(this.legalName, bankTransferUser.legalName) && Objects.equals(this.emailAddress, bankTransferUser.emailAddress) && Objects.equals(this.routingNumber, bankTransferUser.routingNumber);
    }

    public int hashCode() {
        return Objects.hash(this.legalName, this.emailAddress, this.routingNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransferUser {\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

