/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BaseReportItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing a Base Report")
public class BaseReport {
    public static final String SERIALIZED_NAME_REPORT_ID = "report_id";
    @SerializedName(value="report_id")
    private String reportId;
    public static final String SERIALIZED_NAME_DATE_GENERATED = "date_generated";
    @SerializedName(value="date_generated")
    private OffsetDateTime dateGenerated;
    public static final String SERIALIZED_NAME_DAYS_REQUESTED = "days_requested";
    @SerializedName(value="days_requested")
    private Double daysRequested;
    public static final String SERIALIZED_NAME_CLIENT_REPORT_ID = "client_report_id";
    @SerializedName(value="client_report_id")
    private String clientReportId;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<BaseReportItem> items = new ArrayList<BaseReportItem>();

    public BaseReport reportId(String reportId) {
        this.reportId = reportId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique ID identifying an Base Report. Like all Plaid identifiers, this ID is case sensitive.")
    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public BaseReport dateGenerated(OffsetDateTime dateGenerated) {
        this.dateGenerated = dateGenerated;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time when the Base Report was created, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (e.g. \"2018-04-12T03:32:11Z\").")
    public OffsetDateTime getDateGenerated() {
        return this.dateGenerated;
    }

    public void setDateGenerated(OffsetDateTime dateGenerated) {
        this.dateGenerated = dateGenerated;
    }

    public BaseReport daysRequested(Double daysRequested) {
        this.daysRequested = daysRequested;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of days of transaction history requested.")
    public Double getDaysRequested() {
        return this.daysRequested;
    }

    public void setDaysRequested(Double daysRequested) {
        this.daysRequested = daysRequested;
    }

    public BaseReport clientReportId(String clientReportId) {
        this.clientReportId = clientReportId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Client-generated identifier, which can be used by lenders to track loan applications.")
    public String getClientReportId() {
        return this.clientReportId;
    }

    public void setClientReportId(String clientReportId) {
        this.clientReportId = clientReportId;
    }

    public BaseReport items(List<BaseReportItem> items) {
        this.items = items;
        return this;
    }

    public BaseReport addItemsItem(BaseReportItem itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Data returned by Plaid about each of the Items included in the Base Report.")
    public List<BaseReportItem> getItems() {
        return this.items;
    }

    public void setItems(List<BaseReportItem> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseReport baseReport = (BaseReport)o;
        return Objects.equals(this.reportId, baseReport.reportId) && Objects.equals(this.dateGenerated, baseReport.dateGenerated) && Objects.equals(this.daysRequested, baseReport.daysRequested) && Objects.equals(this.clientReportId, baseReport.clientReportId) && Objects.equals(this.items, baseReport.items);
    }

    public int hashCode() {
        return Objects.hash(this.reportId, this.dateGenerated, this.daysRequested, this.clientReportId, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseReport {\n");
        sb.append("    reportId: ").append(this.toIndentedString(this.reportId)).append("\n");
        sb.append("    dateGenerated: ").append(this.toIndentedString(this.dateGenerated)).append("\n");
        sb.append("    daysRequested: ").append(this.toIndentedString(this.daysRequested)).append("\n");
        sb.append("    clientReportId: ").append(this.toIndentedString(this.clientReportId)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

