/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BaseReportAverageFlowInsights;
import com.plaid.client.model.BaseReportLongestGapInsights;
import com.plaid.client.model.BaseReportNumberFlowInsights;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Calculated insights derived from transaction-level data.")
public class BaseReportAccountInsights {
    public static final String SERIALIZED_NAME_OLDEST_TRANSACTION_DATE = "oldest_transaction_date";
    @SerializedName(value="oldest_transaction_date")
    private LocalDate oldestTransactionDate;
    public static final String SERIALIZED_NAME_MOST_RECENT_TRANSACTION_DATE = "most_recent_transaction_date";
    @SerializedName(value="most_recent_transaction_date")
    private LocalDate mostRecentTransactionDate;
    public static final String SERIALIZED_NAME_DAYS_AVAILABLE = "days_available";
    @SerializedName(value="days_available")
    private Integer daysAvailable;
    public static final String SERIALIZED_NAME_AVERAGE_DAYS_BETWEEN_TRANSACTIONS = "average_days_between_transactions";
    @SerializedName(value="average_days_between_transactions")
    private Double averageDaysBetweenTransactions;
    public static final String SERIALIZED_NAME_LONGEST_GAP_BETWEEN_TRANSACTIONS = "longest_gap_between_transactions";
    @SerializedName(value="longest_gap_between_transactions")
    private List<BaseReportLongestGapInsights> longestGapBetweenTransactions = null;
    public static final String SERIALIZED_NAME_NUMBER_OF_INFLOWS = "number_of_inflows";
    @SerializedName(value="number_of_inflows")
    private List<BaseReportNumberFlowInsights> numberOfInflows = null;
    public static final String SERIALIZED_NAME_AVERAGE_INFLOW_AMOUNT = "average_inflow_amount";
    @SerializedName(value="average_inflow_amount")
    private List<BaseReportAverageFlowInsights> averageInflowAmount = null;
    public static final String SERIALIZED_NAME_NUMBER_OF_OUTFLOWS = "number_of_outflows";
    @SerializedName(value="number_of_outflows")
    private List<BaseReportNumberFlowInsights> numberOfOutflows = null;
    public static final String SERIALIZED_NAME_AVERAGE_OUTFLOW_AMOUNT = "average_outflow_amount";
    @SerializedName(value="average_outflow_amount")
    private List<BaseReportAverageFlowInsights> averageOutflowAmount = null;
    public static final String SERIALIZED_NAME_NUMBER_OF_DAYS_NO_TRANSACTIONS = "number_of_days_no_transactions";
    @SerializedName(value="number_of_days_no_transactions")
    private Integer numberOfDaysNoTransactions;

    public BaseReportAccountInsights oldestTransactionDate(LocalDate oldestTransactionDate) {
        this.oldestTransactionDate = oldestTransactionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date of the earliest transaction in the base report for the account.")
    public LocalDate getOldestTransactionDate() {
        return this.oldestTransactionDate;
    }

    public void setOldestTransactionDate(LocalDate oldestTransactionDate) {
        this.oldestTransactionDate = oldestTransactionDate;
    }

    public BaseReportAccountInsights mostRecentTransactionDate(LocalDate mostRecentTransactionDate) {
        this.mostRecentTransactionDate = mostRecentTransactionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date of the most recent transaction in the base report for the account.")
    public LocalDate getMostRecentTransactionDate() {
        return this.mostRecentTransactionDate;
    }

    public void setMostRecentTransactionDate(LocalDate mostRecentTransactionDate) {
        this.mostRecentTransactionDate = mostRecentTransactionDate;
    }

    public BaseReportAccountInsights daysAvailable(Integer daysAvailable) {
        this.daysAvailable = daysAvailable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of days days available in the base report for the account.")
    public Integer getDaysAvailable() {
        return this.daysAvailable;
    }

    public void setDaysAvailable(Integer daysAvailable) {
        this.daysAvailable = daysAvailable;
    }

    public BaseReportAccountInsights averageDaysBetweenTransactions(Double averageDaysBetweenTransactions) {
        this.averageDaysBetweenTransactions = averageDaysBetweenTransactions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Average number of days between sequential transactions")
    public Double getAverageDaysBetweenTransactions() {
        return this.averageDaysBetweenTransactions;
    }

    public void setAverageDaysBetweenTransactions(Double averageDaysBetweenTransactions) {
        this.averageDaysBetweenTransactions = averageDaysBetweenTransactions;
    }

    public BaseReportAccountInsights longestGapBetweenTransactions(List<BaseReportLongestGapInsights> longestGapBetweenTransactions) {
        this.longestGapBetweenTransactions = longestGapBetweenTransactions;
        return this;
    }

    public BaseReportAccountInsights addLongestGapBetweenTransactionsItem(BaseReportLongestGapInsights longestGapBetweenTransactionsItem) {
        if (this.longestGapBetweenTransactions == null) {
            this.longestGapBetweenTransactions = new ArrayList<BaseReportLongestGapInsights>();
        }
        this.longestGapBetweenTransactions.add(longestGapBetweenTransactionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Longest gap between sequential transactions")
    public List<BaseReportLongestGapInsights> getLongestGapBetweenTransactions() {
        return this.longestGapBetweenTransactions;
    }

    public void setLongestGapBetweenTransactions(List<BaseReportLongestGapInsights> longestGapBetweenTransactions) {
        this.longestGapBetweenTransactions = longestGapBetweenTransactions;
    }

    public BaseReportAccountInsights numberOfInflows(List<BaseReportNumberFlowInsights> numberOfInflows) {
        this.numberOfInflows = numberOfInflows;
        return this;
    }

    public BaseReportAccountInsights addNumberOfInflowsItem(BaseReportNumberFlowInsights numberOfInflowsItem) {
        if (this.numberOfInflows == null) {
            this.numberOfInflows = new ArrayList<BaseReportNumberFlowInsights>();
        }
        this.numberOfInflows.add(numberOfInflowsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of debits into the account. This field will be null for non-depository accounts.")
    public List<BaseReportNumberFlowInsights> getNumberOfInflows() {
        return this.numberOfInflows;
    }

    public void setNumberOfInflows(List<BaseReportNumberFlowInsights> numberOfInflows) {
        this.numberOfInflows = numberOfInflows;
    }

    public BaseReportAccountInsights averageInflowAmount(List<BaseReportAverageFlowInsights> averageInflowAmount) {
        this.averageInflowAmount = averageInflowAmount;
        return this;
    }

    public BaseReportAccountInsights addAverageInflowAmountItem(BaseReportAverageFlowInsights averageInflowAmountItem) {
        if (this.averageInflowAmount == null) {
            this.averageInflowAmount = new ArrayList<BaseReportAverageFlowInsights>();
        }
        this.averageInflowAmount.add(averageInflowAmountItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Average amount of debit transactions into account. This field will be null for non-depository accounts. This field only takes into account USD transactions from the account.")
    public List<BaseReportAverageFlowInsights> getAverageInflowAmount() {
        return this.averageInflowAmount;
    }

    public void setAverageInflowAmount(List<BaseReportAverageFlowInsights> averageInflowAmount) {
        this.averageInflowAmount = averageInflowAmount;
    }

    public BaseReportAccountInsights numberOfOutflows(List<BaseReportNumberFlowInsights> numberOfOutflows) {
        this.numberOfOutflows = numberOfOutflows;
        return this;
    }

    public BaseReportAccountInsights addNumberOfOutflowsItem(BaseReportNumberFlowInsights numberOfOutflowsItem) {
        if (this.numberOfOutflows == null) {
            this.numberOfOutflows = new ArrayList<BaseReportNumberFlowInsights>();
        }
        this.numberOfOutflows.add(numberOfOutflowsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of credit into the account. This field will be null for non-depository accounts.")
    public List<BaseReportNumberFlowInsights> getNumberOfOutflows() {
        return this.numberOfOutflows;
    }

    public void setNumberOfOutflows(List<BaseReportNumberFlowInsights> numberOfOutflows) {
        this.numberOfOutflows = numberOfOutflows;
    }

    public BaseReportAccountInsights averageOutflowAmount(List<BaseReportAverageFlowInsights> averageOutflowAmount) {
        this.averageOutflowAmount = averageOutflowAmount;
        return this;
    }

    public BaseReportAccountInsights addAverageOutflowAmountItem(BaseReportAverageFlowInsights averageOutflowAmountItem) {
        if (this.averageOutflowAmount == null) {
            this.averageOutflowAmount = new ArrayList<BaseReportAverageFlowInsights>();
        }
        this.averageOutflowAmount.add(averageOutflowAmountItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Average amount of credit transactions into account. This field will be null for non-depository accounts. This field only takes into account USD transactions from the account.")
    public List<BaseReportAverageFlowInsights> getAverageOutflowAmount() {
        return this.averageOutflowAmount;
    }

    public void setAverageOutflowAmount(List<BaseReportAverageFlowInsights> averageOutflowAmount) {
        this.averageOutflowAmount = averageOutflowAmount;
    }

    public BaseReportAccountInsights numberOfDaysNoTransactions(Integer numberOfDaysNoTransactions) {
        this.numberOfDaysNoTransactions = numberOfDaysNoTransactions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of days with no transactions")
    public Integer getNumberOfDaysNoTransactions() {
        return this.numberOfDaysNoTransactions;
    }

    public void setNumberOfDaysNoTransactions(Integer numberOfDaysNoTransactions) {
        this.numberOfDaysNoTransactions = numberOfDaysNoTransactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseReportAccountInsights baseReportAccountInsights = (BaseReportAccountInsights)o;
        return Objects.equals(this.oldestTransactionDate, baseReportAccountInsights.oldestTransactionDate) && Objects.equals(this.mostRecentTransactionDate, baseReportAccountInsights.mostRecentTransactionDate) && Objects.equals(this.daysAvailable, baseReportAccountInsights.daysAvailable) && Objects.equals(this.averageDaysBetweenTransactions, baseReportAccountInsights.averageDaysBetweenTransactions) && Objects.equals(this.longestGapBetweenTransactions, baseReportAccountInsights.longestGapBetweenTransactions) && Objects.equals(this.numberOfInflows, baseReportAccountInsights.numberOfInflows) && Objects.equals(this.averageInflowAmount, baseReportAccountInsights.averageInflowAmount) && Objects.equals(this.numberOfOutflows, baseReportAccountInsights.numberOfOutflows) && Objects.equals(this.averageOutflowAmount, baseReportAccountInsights.averageOutflowAmount) && Objects.equals(this.numberOfDaysNoTransactions, baseReportAccountInsights.numberOfDaysNoTransactions);
    }

    public int hashCode() {
        return Objects.hash(this.oldestTransactionDate, this.mostRecentTransactionDate, this.daysAvailable, this.averageDaysBetweenTransactions, this.longestGapBetweenTransactions, this.numberOfInflows, this.averageInflowAmount, this.numberOfOutflows, this.averageOutflowAmount, this.numberOfDaysNoTransactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseReportAccountInsights {\n");
        sb.append("    oldestTransactionDate: ").append(this.toIndentedString(this.oldestTransactionDate)).append("\n");
        sb.append("    mostRecentTransactionDate: ").append(this.toIndentedString(this.mostRecentTransactionDate)).append("\n");
        sb.append("    daysAvailable: ").append(this.toIndentedString(this.daysAvailable)).append("\n");
        sb.append("    averageDaysBetweenTransactions: ").append(this.toIndentedString(this.averageDaysBetweenTransactions)).append("\n");
        sb.append("    longestGapBetweenTransactions: ").append(this.toIndentedString(this.longestGapBetweenTransactions)).append("\n");
        sb.append("    numberOfInflows: ").append(this.toIndentedString(this.numberOfInflows)).append("\n");
        sb.append("    averageInflowAmount: ").append(this.toIndentedString(this.averageInflowAmount)).append("\n");
        sb.append("    numberOfOutflows: ").append(this.toIndentedString(this.numberOfOutflows)).append("\n");
        sb.append("    averageOutflowAmount: ").append(this.toIndentedString(this.averageOutflowAmount)).append("\n");
        sb.append("    numberOfDaysNoTransactions: ").append(this.toIndentedString(this.numberOfDaysNoTransactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

