/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditAmountWithCurrency;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Average dollar amount of credit or debit transactions out of the account. This field will only added for depository accounts")
public class BaseReportAverageFlowInsights {
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_TOTAL_AMOUNT = "total_amount";
    @SerializedName(value="total_amount")
    private CreditAmountWithCurrency totalAmount;

    public BaseReportAverageFlowInsights startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The start date of this time period. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public BaseReportAverageFlowInsights endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end date of this time period. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public BaseReportAverageFlowInsights totalAmount(CreditAmountWithCurrency totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreditAmountWithCurrency getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(CreditAmountWithCurrency totalAmount) {
        this.totalAmount = totalAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseReportAverageFlowInsights baseReportAverageFlowInsights = (BaseReportAverageFlowInsights)o;
        return Objects.equals(this.startDate, baseReportAverageFlowInsights.startDate) && Objects.equals(this.endDate, baseReportAverageFlowInsights.endDate) && Objects.equals(this.totalAmount, baseReportAverageFlowInsights.totalAmount);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.totalAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseReportAverageFlowInsights {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

