/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BaseReport;
import com.plaid.client.model.BaseReportWarning;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="BaseReportGetResponse defines the response schema for `/cra/base_report/get`")
public class BaseReportGetResponse {
    public static final String SERIALIZED_NAME_REPORT = "report";
    @SerializedName(value="report")
    private BaseReport report;
    public static final String SERIALIZED_NAME_WARNINGS = "warnings";
    @SerializedName(value="warnings")
    private List<BaseReportWarning> warnings = null;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public BaseReportGetResponse report(BaseReport report) {
        this.report = report;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BaseReport getReport() {
        return this.report;
    }

    public void setReport(BaseReport report) {
        this.report = report;
    }

    public BaseReportGetResponse warnings(List<BaseReportWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public BaseReportGetResponse addWarningsItem(BaseReportWarning warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<BaseReportWarning>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the Base Report generation was successful but identity information cannot be returned, this array will contain information about the errors causing identity information to be missing")
    public List<BaseReportWarning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<BaseReportWarning> warnings) {
        this.warnings = warnings;
    }

    public BaseReportGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseReportGetResponse baseReportGetResponse = (BaseReportGetResponse)o;
        return Objects.equals(this.report, baseReportGetResponse.report) && Objects.equals(this.warnings, baseReportGetResponse.warnings) && Objects.equals(this.requestId, baseReportGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.report, this.warnings, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseReportGetResponse {\n");
        sb.append("    report: ").append(this.toIndentedString(this.report)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

