/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Largest number of days between sequential transactions per calendar month")
public class BaseReportLongestGapInsights {
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_DAYS = "days";
    @SerializedName(value="days")
    private Integer days;

    public BaseReportLongestGapInsights startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The start date of this time period. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public BaseReportLongestGapInsights endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end date of this time period. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public BaseReportLongestGapInsights days(Integer days) {
        this.days = days;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Largest number of days between sequential transactions for this time period.")
    public Integer getDays() {
        return this.days;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseReportLongestGapInsights baseReportLongestGapInsights = (BaseReportLongestGapInsights)o;
        return Objects.equals(this.startDate, baseReportLongestGapInsights.startDate) && Objects.equals(this.endDate, baseReportLongestGapInsights.endDate) && Objects.equals(this.days, baseReportLongestGapInsights.days);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.days);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseReportLongestGapInsights {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    days: ").append(this.toIndentedString(this.days)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

