/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The number of credits or debits out of the account. This field will only added for depository accounts")
public class BaseReportNumberFlowInsights {
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count;

    public BaseReportNumberFlowInsights startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The start date of this time period. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public BaseReportNumberFlowInsights endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end date of this time period. The date will be returned in an ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public BaseReportNumberFlowInsights count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of credits or debits out of the account for this time period.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseReportNumberFlowInsights baseReportNumberFlowInsights = (BaseReportNumberFlowInsights)o;
        return Objects.equals(this.startDate, baseReportNumberFlowInsights.startDate) && Objects.equals(this.endDate, baseReportNumberFlowInsights.endDate) && Objects.equals(this.count, baseReportNumberFlowInsights.count);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.count);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseReportNumberFlowInsights {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

