/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BaseReportTransactionType;
import com.plaid.client.model.CreditCategory;
import com.plaid.client.model.Location;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A transaction on the Base Report")
public class BaseReportTransaction {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;
    public static final String SERIALIZED_NAME_ORIGINAL_DESCRIPTION = "original_description";
    @SerializedName(value="original_description")
    private String originalDescription;
    public static final String SERIALIZED_NAME_CREDIT_CATEGORY = "credit_category";
    @SerializedName(value="credit_category")
    private CreditCategory creditCategory;
    public static final String SERIALIZED_NAME_CHECK_NUMBER = "check_number";
    @SerializedName(value="check_number")
    private String checkNumber;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private LocalDate date;
    public static final String SERIALIZED_NAME_DATE_TRANSACTED = "date_transacted";
    @SerializedName(value="date_transacted")
    private String dateTransacted;
    public static final String SERIALIZED_NAME_LOCATION = "location";
    @SerializedName(value="location")
    private Location location;
    public static final String SERIALIZED_NAME_MERCHANT_NAME = "merchant_name";
    @SerializedName(value="merchant_name")
    private String merchantName;
    public static final String SERIALIZED_NAME_PENDING = "pending";
    @SerializedName(value="pending")
    private Boolean pending;
    public static final String SERIALIZED_NAME_ACCOUNT_OWNER = "account_owner";
    @SerializedName(value="account_owner")
    private String accountOwner;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transaction_id";
    @SerializedName(value="transaction_id")
    private String transactionId;
    public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transaction_type";
    @SerializedName(value="transaction_type")
    private BaseReportTransactionType transactionType;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private List<String> category = null;
    public static final String SERIALIZED_NAME_CATEGORY_ID = "category_id";
    @SerializedName(value="category_id")
    private Object categoryId = null;

    public BaseReportTransaction accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the account in which this transaction occurred.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BaseReportTransaction amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The settled value of the transaction, denominated in the transaction's currency, as stated in `iso_currency_code` or `unofficial_currency_code`. Positive values when money moves out of the account; negative values when money moves in. For example, debit card purchases are positive; credit card payments, direct deposits, and refunds are negative.")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public BaseReportTransaction isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the transaction. Always `null` if `unofficial_currency_code` is non-null.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public BaseReportTransaction unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The unofficial currency code associated with the transaction. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `unofficial_currency_code`s.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public BaseReportTransaction originalDescription(String originalDescription) {
        this.originalDescription = originalDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The string returned by the financial institution to describe the transaction.")
    public String getOriginalDescription() {
        return this.originalDescription;
    }

    public void setOriginalDescription(String originalDescription) {
        this.originalDescription = originalDescription;
    }

    public BaseReportTransaction creditCategory(CreditCategory creditCategory) {
        this.creditCategory = creditCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreditCategory getCreditCategory() {
        return this.creditCategory;
    }

    public void setCreditCategory(CreditCategory creditCategory) {
        this.creditCategory = creditCategory;
    }

    public BaseReportTransaction checkNumber(String checkNumber) {
        this.checkNumber = checkNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The check number of the transaction. This field is only populated for check transactions.")
    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public BaseReportTransaction date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(required=true, value="For pending transactions, the date that the transaction occurred; for posted transactions, the date that the transaction posted. Both dates are returned in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format ( `YYYY-MM-DD` ).")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public BaseReportTransaction dateTransacted(String dateTransacted) {
        this.dateTransacted = dateTransacted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date on which the transaction took place, in IS0 8601 format.")
    public String getDateTransacted() {
        return this.dateTransacted;
    }

    public void setDateTransacted(String dateTransacted) {
        this.dateTransacted = dateTransacted;
    }

    public BaseReportTransaction location(Location location) {
        this.location = location;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public BaseReportTransaction merchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The merchant name, as enriched by Plaid from the `name` field. This is typically a more human-readable version of the merchant counterparty in the transaction. For some bank transactions (such as checks or account transfers) where there is no meaningful merchant name, this value will be `null`.")
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public BaseReportTransaction pending(Boolean pending) {
        this.pending = pending;
        return this;
    }

    @ApiModelProperty(required=true, value="When `true`, identifies the transaction as pending or unsettled. Pending transaction details (name, type, amount, category ID) may change before they are settled.")
    public Boolean getPending() {
        return this.pending;
    }

    public void setPending(Boolean pending) {
        this.pending = pending;
    }

    public BaseReportTransaction accountOwner(String accountOwner) {
        this.accountOwner = accountOwner;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the account owner. This field is not typically populated and only relevant when dealing with sub-accounts.")
    public String getAccountOwner() {
        return this.accountOwner;
    }

    public void setAccountOwner(String accountOwner) {
        this.accountOwner = accountOwner;
    }

    public BaseReportTransaction transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique ID of the transaction. Like all Plaid identifiers, the `transaction_id` is case sensitive.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public BaseReportTransaction transactionType(BaseReportTransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BaseReportTransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(BaseReportTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public BaseReportTransaction category(List<String> category) {
        this.category = category;
        return this;
    }

    public BaseReportTransaction addCategoryItem(String categoryItem) {
        if (this.category == null) {
            this.category = new ArrayList<String>();
        }
        this.category.add(categoryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A hierarchical array of the categories to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/transactions/#categoriesget).")
    public List<String> getCategory() {
        return this.category;
    }

    public void setCategory(List<String> category) {
        this.category = category;
    }

    public BaseReportTransaction categoryId(Object categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the category to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/transactions/#categoriesget).")
    public Object getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Object categoryId) {
        this.categoryId = categoryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseReportTransaction baseReportTransaction = (BaseReportTransaction)o;
        return Objects.equals(this.accountId, baseReportTransaction.accountId) && Objects.equals(this.amount, baseReportTransaction.amount) && Objects.equals(this.isoCurrencyCode, baseReportTransaction.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, baseReportTransaction.unofficialCurrencyCode) && Objects.equals(this.originalDescription, baseReportTransaction.originalDescription) && Objects.equals(this.creditCategory, baseReportTransaction.creditCategory) && Objects.equals(this.checkNumber, baseReportTransaction.checkNumber) && Objects.equals(this.date, baseReportTransaction.date) && Objects.equals(this.dateTransacted, baseReportTransaction.dateTransacted) && Objects.equals(this.location, baseReportTransaction.location) && Objects.equals(this.merchantName, baseReportTransaction.merchantName) && Objects.equals(this.pending, baseReportTransaction.pending) && Objects.equals(this.accountOwner, baseReportTransaction.accountOwner) && Objects.equals(this.transactionId, baseReportTransaction.transactionId) && Objects.equals((Object)this.transactionType, (Object)baseReportTransaction.transactionType) && Objects.equals(this.category, baseReportTransaction.category) && Objects.equals(this.categoryId, baseReportTransaction.categoryId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.amount, this.isoCurrencyCode, this.unofficialCurrencyCode, this.originalDescription, this.creditCategory, this.checkNumber, this.date, this.dateTransacted, this.location, this.merchantName, this.pending, this.accountOwner, this.transactionId, this.transactionType, this.category, this.categoryId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseReportTransaction {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("    originalDescription: ").append(this.toIndentedString(this.originalDescription)).append("\n");
        sb.append("    creditCategory: ").append(this.toIndentedString(this.creditCategory)).append("\n");
        sb.append("    checkNumber: ").append(this.toIndentedString(this.checkNumber)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    dateTransacted: ").append(this.toIndentedString(this.dateTransacted)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    merchantName: ").append(this.toIndentedString(this.merchantName)).append("\n");
        sb.append("    pending: ").append(this.toIndentedString(this.pending)).append("\n");
        sb.append("    accountOwner: ").append(this.toIndentedString(this.accountOwner)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString((Object)this.transactionType)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

