/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BaseReportWarningCode;
import com.plaid.client.model.Cause;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="It is possible for a Base Report to be returned with missing account owner information. In such cases, the Base Report will contain warning data in the response, indicating why obtaining the owner information failed.")
public class BaseReportWarning {
    public static final String SERIALIZED_NAME_WARNING_TYPE = "warning_type";
    @SerializedName(value="warning_type")
    private String warningType;
    public static final String SERIALIZED_NAME_WARNING_CODE = "warning_code";
    @SerializedName(value="warning_code")
    private BaseReportWarningCode warningCode;
    public static final String SERIALIZED_NAME_CAUSE = "cause";
    @SerializedName(value="cause")
    private Cause cause;

    public BaseReportWarning warningType(String warningType) {
        this.warningType = warningType;
        return this;
    }

    @ApiModelProperty(required=true, value="The warning type, which will always be `BASE_REPORT_WARNING`")
    public String getWarningType() {
        return this.warningType;
    }

    public void setWarningType(String warningType) {
        this.warningType = warningType;
    }

    public BaseReportWarning warningCode(BaseReportWarningCode warningCode) {
        this.warningCode = warningCode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BaseReportWarningCode getWarningCode() {
        return this.warningCode;
    }

    public void setWarningCode(BaseReportWarningCode warningCode) {
        this.warningCode = warningCode;
    }

    public BaseReportWarning cause(Cause cause) {
        this.cause = cause;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Cause getCause() {
        return this.cause;
    }

    public void setCause(Cause cause) {
        this.cause = cause;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseReportWarning baseReportWarning = (BaseReportWarning)o;
        return Objects.equals(this.warningType, baseReportWarning.warningType) && Objects.equals((Object)this.warningCode, (Object)baseReportWarning.warningCode) && Objects.equals(this.cause, baseReportWarning.cause);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.warningType, this.warningCode, this.cause});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseReportWarning {\n");
        sb.append("    warningType: ").append(this.toIndentedString(this.warningType)).append("\n");
        sb.append("    warningCode: ").append(this.toIndentedString((Object)this.warningCode)).append("\n");
        sb.append("    cause: ").append(this.toIndentedString(this.cause)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

