/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The attributes object contains data that can be used to assess account risk. Examples of data include: `days_since_first_plaid_connection`: The number of days since the first time the Item was connected to an application via Plaid `plaid_connections_count_7d`: The number of times the Item has been connected to applications via Plaid over the past 7 days `plaid_connections_count_30d`: The number of times the Item has been connected to applications via Plaid over the past 30 days `total_plaid_connections_count`: The number of times the Item has been connected to applications via Plaid For the full list and detailed documentation of core attributes available, or to request that core attributes not be returned, contact Sales or your Plaid account manager")
public class BeaconAccountRiskEvaluateAccountAttributes {
    public static final String SERIALIZED_NAME_DAYS_SINCE_FIRST_PLAID_CONNECTION = "days_since_first_plaid_connection";
    @SerializedName(value="days_since_first_plaid_connection")
    private Integer daysSinceFirstPlaidConnection;
    public static final String SERIALIZED_NAME_IS_ACCOUNT_CLOSED = "is_account_closed";
    @SerializedName(value="is_account_closed")
    private Boolean isAccountClosed;
    public static final String SERIALIZED_NAME_IS_ACCOUNT_FROZEN_OR_RESTRICTED = "is_account_frozen_or_restricted";
    @SerializedName(value="is_account_frozen_or_restricted")
    private Boolean isAccountFrozenOrRestricted;
    public static final String SERIALIZED_NAME_TOTAL_PLAID_CONNECTIONS_COUNT = "total_plaid_connections_count";
    @SerializedName(value="total_plaid_connections_count")
    private Integer totalPlaidConnectionsCount;
    public static final String SERIALIZED_NAME_PLAID_CONNECTIONS_COUNT7D = "plaid_connections_count_7d";
    @SerializedName(value="plaid_connections_count_7d")
    private Integer plaidConnectionsCount7d;
    public static final String SERIALIZED_NAME_PLAID_CONNECTIONS_COUNT30D = "plaid_connections_count_30d";
    @SerializedName(value="plaid_connections_count_30d")
    private Integer plaidConnectionsCount30d;
    public static final String SERIALIZED_NAME_FAILED_PLAID_NON_OAUTH_AUTHENTICATION_ATTEMPTS_COUNT3D = "failed_plaid_non_oauth_authentication_attempts_count_3d";
    @SerializedName(value="failed_plaid_non_oauth_authentication_attempts_count_3d")
    private Integer failedPlaidNonOauthAuthenticationAttemptsCount3d;
    public static final String SERIALIZED_NAME_PLAID_NON_OAUTH_AUTHENTICATION_ATTEMPTS_COUNT3D = "plaid_non_oauth_authentication_attempts_count_3d";
    @SerializedName(value="plaid_non_oauth_authentication_attempts_count_3d")
    private Integer plaidNonOauthAuthenticationAttemptsCount3d;
    public static final String SERIALIZED_NAME_FAILED_PLAID_NON_OAUTH_AUTHENTICATION_ATTEMPTS_COUNT7D = "failed_plaid_non_oauth_authentication_attempts_count_7d";
    @SerializedName(value="failed_plaid_non_oauth_authentication_attempts_count_7d")
    private Integer failedPlaidNonOauthAuthenticationAttemptsCount7d;
    public static final String SERIALIZED_NAME_PLAID_NON_OAUTH_AUTHENTICATION_ATTEMPTS_COUNT7D = "plaid_non_oauth_authentication_attempts_count_7d";
    @SerializedName(value="plaid_non_oauth_authentication_attempts_count_7d")
    private Integer plaidNonOauthAuthenticationAttemptsCount7d;
    public static final String SERIALIZED_NAME_FAILED_PLAID_NON_OAUTH_AUTHENTICATION_ATTEMPTS_COUNT30D = "failed_plaid_non_oauth_authentication_attempts_count_30d";
    @SerializedName(value="failed_plaid_non_oauth_authentication_attempts_count_30d")
    private Integer failedPlaidNonOauthAuthenticationAttemptsCount30d;
    public static final String SERIALIZED_NAME_PLAID_NON_OAUTH_AUTHENTICATION_ATTEMPTS_COUNT30D = "plaid_non_oauth_authentication_attempts_count_30d";
    @SerializedName(value="plaid_non_oauth_authentication_attempts_count_30d")
    private Integer plaidNonOauthAuthenticationAttemptsCount30d;
    public static final String SERIALIZED_NAME_DISTINCT_IP_ADDRESSES_COUNT3D = "distinct_ip_addresses_count_3d";
    @SerializedName(value="distinct_ip_addresses_count_3d")
    private Integer distinctIpAddressesCount3d;
    public static final String SERIALIZED_NAME_DISTINCT_IP_ADDRESSES_COUNT7D = "distinct_ip_addresses_count_7d";
    @SerializedName(value="distinct_ip_addresses_count_7d")
    private Integer distinctIpAddressesCount7d;
    public static final String SERIALIZED_NAME_DISTINCT_IP_ADDRESSES_COUNT30D = "distinct_ip_addresses_count_30d";
    @SerializedName(value="distinct_ip_addresses_count_30d")
    private Integer distinctIpAddressesCount30d;
    public static final String SERIALIZED_NAME_DISTINCT_IP_ADDRESSES_COUNT90D = "distinct_ip_addresses_count_90d";
    @SerializedName(value="distinct_ip_addresses_count_90d")
    private Integer distinctIpAddressesCount90d;
    public static final String SERIALIZED_NAME_DISTINCT_USER_AGENTS_COUNT3D = "distinct_user_agents_count_3d";
    @SerializedName(value="distinct_user_agents_count_3d")
    private Integer distinctUserAgentsCount3d;
    public static final String SERIALIZED_NAME_DISTINCT_USER_AGENTS_COUNT7D = "distinct_user_agents_count_7d";
    @SerializedName(value="distinct_user_agents_count_7d")
    private Integer distinctUserAgentsCount7d;
    public static final String SERIALIZED_NAME_DISTINCT_USER_AGENTS_COUNT30D = "distinct_user_agents_count_30d";
    @SerializedName(value="distinct_user_agents_count_30d")
    private Integer distinctUserAgentsCount30d;
    public static final String SERIALIZED_NAME_DISTINCT_USER_AGENTS_COUNT90D = "distinct_user_agents_count_90d";
    @SerializedName(value="distinct_user_agents_count_90d")
    private Integer distinctUserAgentsCount90d;
    public static final String SERIALIZED_NAME_ADDRESS_CHANGE_COUNT28D = "address_change_count_28d";
    @SerializedName(value="address_change_count_28d")
    private Integer addressChangeCount28d;
    public static final String SERIALIZED_NAME_EMAIL_CHANGE_COUNT28D = "email_change_count_28d";
    @SerializedName(value="email_change_count_28d")
    private Integer emailChangeCount28d;
    public static final String SERIALIZED_NAME_PHONE_CHANGE_COUNT28D = "phone_change_count_28d";
    @SerializedName(value="phone_change_count_28d")
    private Integer phoneChangeCount28d;
    public static final String SERIALIZED_NAME_ADDRESS_CHANGE_COUNT90D = "address_change_count_90d";
    @SerializedName(value="address_change_count_90d")
    private Integer addressChangeCount90d;
    public static final String SERIALIZED_NAME_EMAIL_CHANGE_COUNT90D = "email_change_count_90d";
    @SerializedName(value="email_change_count_90d")
    private Integer emailChangeCount90d;
    public static final String SERIALIZED_NAME_PHONE_CHANGE_COUNT90D = "phone_change_count_90d";
    @SerializedName(value="phone_change_count_90d")
    private Integer phoneChangeCount90d;
    public static final String SERIALIZED_NAME_DAYS_SINCE_ACCOUNT_OPENING = "days_since_account_opening";
    @SerializedName(value="days_since_account_opening")
    private Integer daysSinceAccountOpening;
    public static final String SERIALIZED_NAME_DAYS_SINCE_FIRST_OBSERVED_TRANSACTION = "days_since_first_observed_transaction";
    @SerializedName(value="days_since_first_observed_transaction")
    private Integer daysSinceFirstObservedTransaction;

    public BeaconAccountRiskEvaluateAccountAttributes daysSinceFirstPlaidConnection(Integer daysSinceFirstPlaidConnection) {
        this.daysSinceFirstPlaidConnection = daysSinceFirstPlaidConnection;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of days since the first time the Item was connected to an application via Plaid")
    public Integer getDaysSinceFirstPlaidConnection() {
        return this.daysSinceFirstPlaidConnection;
    }

    public void setDaysSinceFirstPlaidConnection(Integer daysSinceFirstPlaidConnection) {
        this.daysSinceFirstPlaidConnection = daysSinceFirstPlaidConnection;
    }

    public BeaconAccountRiskEvaluateAccountAttributes isAccountClosed(Boolean isAccountClosed) {
        this.isAccountClosed = isAccountClosed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the account has been closed by the financial institution or the consumer, or is at risk of being closed")
    public Boolean getIsAccountClosed() {
        return this.isAccountClosed;
    }

    public void setIsAccountClosed(Boolean isAccountClosed) {
        this.isAccountClosed = isAccountClosed;
    }

    public BeaconAccountRiskEvaluateAccountAttributes isAccountFrozenOrRestricted(Boolean isAccountFrozenOrRestricted) {
        this.isAccountFrozenOrRestricted = isAccountFrozenOrRestricted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the account has withdrawals and transfers disabled or if access to the account is restricted. This could be due to a freeze by the credit issuer, legal restrictions (e.g., sanctions), or regulatory requirements limiting monthly withdrawals, among other reasons")
    public Boolean getIsAccountFrozenOrRestricted() {
        return this.isAccountFrozenOrRestricted;
    }

    public void setIsAccountFrozenOrRestricted(Boolean isAccountFrozenOrRestricted) {
        this.isAccountFrozenOrRestricted = isAccountFrozenOrRestricted;
    }

    public BeaconAccountRiskEvaluateAccountAttributes totalPlaidConnectionsCount(Integer totalPlaidConnectionsCount) {
        this.totalPlaidConnectionsCount = totalPlaidConnectionsCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of times the item has been connected to applications via Plaid")
    public Integer getTotalPlaidConnectionsCount() {
        return this.totalPlaidConnectionsCount;
    }

    public void setTotalPlaidConnectionsCount(Integer totalPlaidConnectionsCount) {
        this.totalPlaidConnectionsCount = totalPlaidConnectionsCount;
    }

    public BeaconAccountRiskEvaluateAccountAttributes plaidConnectionsCount7d(Integer plaidConnectionsCount7d) {
        this.plaidConnectionsCount7d = plaidConnectionsCount7d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the Item has been connected to applications via Plaid over the past 7 days")
    public Integer getPlaidConnectionsCount7d() {
        return this.plaidConnectionsCount7d;
    }

    public void setPlaidConnectionsCount7d(Integer plaidConnectionsCount7d) {
        this.plaidConnectionsCount7d = plaidConnectionsCount7d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes plaidConnectionsCount30d(Integer plaidConnectionsCount30d) {
        this.plaidConnectionsCount30d = plaidConnectionsCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the Item has been connected to applications via Plaid over the past 30 days")
    public Integer getPlaidConnectionsCount30d() {
        return this.plaidConnectionsCount30d;
    }

    public void setPlaidConnectionsCount30d(Integer plaidConnectionsCount30d) {
        this.plaidConnectionsCount30d = plaidConnectionsCount30d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes failedPlaidNonOauthAuthenticationAttemptsCount3d(Integer failedPlaidNonOauthAuthenticationAttemptsCount3d) {
        this.failedPlaidNonOauthAuthenticationAttemptsCount3d = failedPlaidNonOauthAuthenticationAttemptsCount3d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of failed non-OAuth authentication attempts via Plaid for this bank account over the past 3 days")
    public Integer getFailedPlaidNonOauthAuthenticationAttemptsCount3d() {
        return this.failedPlaidNonOauthAuthenticationAttemptsCount3d;
    }

    public void setFailedPlaidNonOauthAuthenticationAttemptsCount3d(Integer failedPlaidNonOauthAuthenticationAttemptsCount3d) {
        this.failedPlaidNonOauthAuthenticationAttemptsCount3d = failedPlaidNonOauthAuthenticationAttemptsCount3d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes plaidNonOauthAuthenticationAttemptsCount3d(Integer plaidNonOauthAuthenticationAttemptsCount3d) {
        this.plaidNonOauthAuthenticationAttemptsCount3d = plaidNonOauthAuthenticationAttemptsCount3d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of non-OAuth authentication attempts via Plaid for this bank account over the past 3 days")
    public Integer getPlaidNonOauthAuthenticationAttemptsCount3d() {
        return this.plaidNonOauthAuthenticationAttemptsCount3d;
    }

    public void setPlaidNonOauthAuthenticationAttemptsCount3d(Integer plaidNonOauthAuthenticationAttemptsCount3d) {
        this.plaidNonOauthAuthenticationAttemptsCount3d = plaidNonOauthAuthenticationAttemptsCount3d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes failedPlaidNonOauthAuthenticationAttemptsCount7d(Integer failedPlaidNonOauthAuthenticationAttemptsCount7d) {
        this.failedPlaidNonOauthAuthenticationAttemptsCount7d = failedPlaidNonOauthAuthenticationAttemptsCount7d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of failed non-OAuth authentication attempts via Plaid for this bank account over the past 7 days")
    public Integer getFailedPlaidNonOauthAuthenticationAttemptsCount7d() {
        return this.failedPlaidNonOauthAuthenticationAttemptsCount7d;
    }

    public void setFailedPlaidNonOauthAuthenticationAttemptsCount7d(Integer failedPlaidNonOauthAuthenticationAttemptsCount7d) {
        this.failedPlaidNonOauthAuthenticationAttemptsCount7d = failedPlaidNonOauthAuthenticationAttemptsCount7d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes plaidNonOauthAuthenticationAttemptsCount7d(Integer plaidNonOauthAuthenticationAttemptsCount7d) {
        this.plaidNonOauthAuthenticationAttemptsCount7d = plaidNonOauthAuthenticationAttemptsCount7d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of non-OAuth authentication attempts via Plaid for this bank account over the past 7 days")
    public Integer getPlaidNonOauthAuthenticationAttemptsCount7d() {
        return this.plaidNonOauthAuthenticationAttemptsCount7d;
    }

    public void setPlaidNonOauthAuthenticationAttemptsCount7d(Integer plaidNonOauthAuthenticationAttemptsCount7d) {
        this.plaidNonOauthAuthenticationAttemptsCount7d = plaidNonOauthAuthenticationAttemptsCount7d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes failedPlaidNonOauthAuthenticationAttemptsCount30d(Integer failedPlaidNonOauthAuthenticationAttemptsCount30d) {
        this.failedPlaidNonOauthAuthenticationAttemptsCount30d = failedPlaidNonOauthAuthenticationAttemptsCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of failed non-OAuth authentication attempts via Plaid for this bank account over the past 30 days")
    public Integer getFailedPlaidNonOauthAuthenticationAttemptsCount30d() {
        return this.failedPlaidNonOauthAuthenticationAttemptsCount30d;
    }

    public void setFailedPlaidNonOauthAuthenticationAttemptsCount30d(Integer failedPlaidNonOauthAuthenticationAttemptsCount30d) {
        this.failedPlaidNonOauthAuthenticationAttemptsCount30d = failedPlaidNonOauthAuthenticationAttemptsCount30d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes plaidNonOauthAuthenticationAttemptsCount30d(Integer plaidNonOauthAuthenticationAttemptsCount30d) {
        this.plaidNonOauthAuthenticationAttemptsCount30d = plaidNonOauthAuthenticationAttemptsCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of non-OAuth authentication attempts via Plaid for this bank account over the past 30 days")
    public Integer getPlaidNonOauthAuthenticationAttemptsCount30d() {
        return this.plaidNonOauthAuthenticationAttemptsCount30d;
    }

    public void setPlaidNonOauthAuthenticationAttemptsCount30d(Integer plaidNonOauthAuthenticationAttemptsCount30d) {
        this.plaidNonOauthAuthenticationAttemptsCount30d = plaidNonOauthAuthenticationAttemptsCount30d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes distinctIpAddressesCount3d(Integer distinctIpAddressesCount3d) {
        this.distinctIpAddressesCount3d = distinctIpAddressesCount3d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct IP addresses linked to the same bank account during Plaid authentication in the last 3 days")
    public Integer getDistinctIpAddressesCount3d() {
        return this.distinctIpAddressesCount3d;
    }

    public void setDistinctIpAddressesCount3d(Integer distinctIpAddressesCount3d) {
        this.distinctIpAddressesCount3d = distinctIpAddressesCount3d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes distinctIpAddressesCount7d(Integer distinctIpAddressesCount7d) {
        this.distinctIpAddressesCount7d = distinctIpAddressesCount7d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct IP addresses linked to the same bank account during Plaid authentication in the last 7 days")
    public Integer getDistinctIpAddressesCount7d() {
        return this.distinctIpAddressesCount7d;
    }

    public void setDistinctIpAddressesCount7d(Integer distinctIpAddressesCount7d) {
        this.distinctIpAddressesCount7d = distinctIpAddressesCount7d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes distinctIpAddressesCount30d(Integer distinctIpAddressesCount30d) {
        this.distinctIpAddressesCount30d = distinctIpAddressesCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct IP addresses linked to the same bank account during Plaid authentication in the last 30 days")
    public Integer getDistinctIpAddressesCount30d() {
        return this.distinctIpAddressesCount30d;
    }

    public void setDistinctIpAddressesCount30d(Integer distinctIpAddressesCount30d) {
        this.distinctIpAddressesCount30d = distinctIpAddressesCount30d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes distinctIpAddressesCount90d(Integer distinctIpAddressesCount90d) {
        this.distinctIpAddressesCount90d = distinctIpAddressesCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct IP addresses linked to the same bank account during Plaid authentication in the last 90 days")
    public Integer getDistinctIpAddressesCount90d() {
        return this.distinctIpAddressesCount90d;
    }

    public void setDistinctIpAddressesCount90d(Integer distinctIpAddressesCount90d) {
        this.distinctIpAddressesCount90d = distinctIpAddressesCount90d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes distinctUserAgentsCount3d(Integer distinctUserAgentsCount3d) {
        this.distinctUserAgentsCount3d = distinctUserAgentsCount3d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct user agents linked to the same bank account during Plaid authentication in the last 3 days")
    public Integer getDistinctUserAgentsCount3d() {
        return this.distinctUserAgentsCount3d;
    }

    public void setDistinctUserAgentsCount3d(Integer distinctUserAgentsCount3d) {
        this.distinctUserAgentsCount3d = distinctUserAgentsCount3d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes distinctUserAgentsCount7d(Integer distinctUserAgentsCount7d) {
        this.distinctUserAgentsCount7d = distinctUserAgentsCount7d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct user agents linked to the same bank account during Plaid authentication in the last 7 days")
    public Integer getDistinctUserAgentsCount7d() {
        return this.distinctUserAgentsCount7d;
    }

    public void setDistinctUserAgentsCount7d(Integer distinctUserAgentsCount7d) {
        this.distinctUserAgentsCount7d = distinctUserAgentsCount7d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes distinctUserAgentsCount30d(Integer distinctUserAgentsCount30d) {
        this.distinctUserAgentsCount30d = distinctUserAgentsCount30d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct user agents linked to the same bank account during Plaid authentication in the last 30 days")
    public Integer getDistinctUserAgentsCount30d() {
        return this.distinctUserAgentsCount30d;
    }

    public void setDistinctUserAgentsCount30d(Integer distinctUserAgentsCount30d) {
        this.distinctUserAgentsCount30d = distinctUserAgentsCount30d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes distinctUserAgentsCount90d(Integer distinctUserAgentsCount90d) {
        this.distinctUserAgentsCount90d = distinctUserAgentsCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of distinct user agents linked to the same bank account during Plaid authentication in the last 90 days")
    public Integer getDistinctUserAgentsCount90d() {
        return this.distinctUserAgentsCount90d;
    }

    public void setDistinctUserAgentsCount90d(Integer distinctUserAgentsCount90d) {
        this.distinctUserAgentsCount90d = distinctUserAgentsCount90d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes addressChangeCount28d(Integer addressChangeCount28d) {
        this.addressChangeCount28d = addressChangeCount28d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the account's addresses on file have changed over the past 28 days")
    public Integer getAddressChangeCount28d() {
        return this.addressChangeCount28d;
    }

    public void setAddressChangeCount28d(Integer addressChangeCount28d) {
        this.addressChangeCount28d = addressChangeCount28d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes emailChangeCount28d(Integer emailChangeCount28d) {
        this.emailChangeCount28d = emailChangeCount28d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the account's email addresses on file have changed over the past 28 days")
    public Integer getEmailChangeCount28d() {
        return this.emailChangeCount28d;
    }

    public void setEmailChangeCount28d(Integer emailChangeCount28d) {
        this.emailChangeCount28d = emailChangeCount28d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes phoneChangeCount28d(Integer phoneChangeCount28d) {
        this.phoneChangeCount28d = phoneChangeCount28d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the account's phone numbers on file have changed over the past 28 days")
    public Integer getPhoneChangeCount28d() {
        return this.phoneChangeCount28d;
    }

    public void setPhoneChangeCount28d(Integer phoneChangeCount28d) {
        this.phoneChangeCount28d = phoneChangeCount28d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes addressChangeCount90d(Integer addressChangeCount90d) {
        this.addressChangeCount90d = addressChangeCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the account's addresses on file have changed over the past 90 days")
    public Integer getAddressChangeCount90d() {
        return this.addressChangeCount90d;
    }

    public void setAddressChangeCount90d(Integer addressChangeCount90d) {
        this.addressChangeCount90d = addressChangeCount90d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes emailChangeCount90d(Integer emailChangeCount90d) {
        this.emailChangeCount90d = emailChangeCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the account's email addresses on file have changed over the past 90 days")
    public Integer getEmailChangeCount90d() {
        return this.emailChangeCount90d;
    }

    public void setEmailChangeCount90d(Integer emailChangeCount90d) {
        this.emailChangeCount90d = emailChangeCount90d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes phoneChangeCount90d(Integer phoneChangeCount90d) {
        this.phoneChangeCount90d = phoneChangeCount90d;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times the account's phone numbers on file have changed over the past 90 days")
    public Integer getPhoneChangeCount90d() {
        return this.phoneChangeCount90d;
    }

    public void setPhoneChangeCount90d(Integer phoneChangeCount90d) {
        this.phoneChangeCount90d = phoneChangeCount90d;
    }

    public BeaconAccountRiskEvaluateAccountAttributes daysSinceAccountOpening(Integer daysSinceAccountOpening) {
        this.daysSinceAccountOpening = daysSinceAccountOpening;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of days since the bank account was opened, as reported by the financial institution")
    public Integer getDaysSinceAccountOpening() {
        return this.daysSinceAccountOpening;
    }

    public void setDaysSinceAccountOpening(Integer daysSinceAccountOpening) {
        this.daysSinceAccountOpening = daysSinceAccountOpening;
    }

    public BeaconAccountRiskEvaluateAccountAttributes daysSinceFirstObservedTransaction(Integer daysSinceFirstObservedTransaction) {
        this.daysSinceFirstObservedTransaction = daysSinceFirstObservedTransaction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of days since the oldest transaction available to Plaid for this account. This measure, combined with Plaid connection history, can be used to infer the age of the account")
    public Integer getDaysSinceFirstObservedTransaction() {
        return this.daysSinceFirstObservedTransaction;
    }

    public void setDaysSinceFirstObservedTransaction(Integer daysSinceFirstObservedTransaction) {
        this.daysSinceFirstObservedTransaction = daysSinceFirstObservedTransaction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconAccountRiskEvaluateAccountAttributes beaconAccountRiskEvaluateAccountAttributes = (BeaconAccountRiskEvaluateAccountAttributes)o;
        return Objects.equals(this.daysSinceFirstPlaidConnection, beaconAccountRiskEvaluateAccountAttributes.daysSinceFirstPlaidConnection) && Objects.equals(this.isAccountClosed, beaconAccountRiskEvaluateAccountAttributes.isAccountClosed) && Objects.equals(this.isAccountFrozenOrRestricted, beaconAccountRiskEvaluateAccountAttributes.isAccountFrozenOrRestricted) && Objects.equals(this.totalPlaidConnectionsCount, beaconAccountRiskEvaluateAccountAttributes.totalPlaidConnectionsCount) && Objects.equals(this.plaidConnectionsCount7d, beaconAccountRiskEvaluateAccountAttributes.plaidConnectionsCount7d) && Objects.equals(this.plaidConnectionsCount30d, beaconAccountRiskEvaluateAccountAttributes.plaidConnectionsCount30d) && Objects.equals(this.failedPlaidNonOauthAuthenticationAttemptsCount3d, beaconAccountRiskEvaluateAccountAttributes.failedPlaidNonOauthAuthenticationAttemptsCount3d) && Objects.equals(this.plaidNonOauthAuthenticationAttemptsCount3d, beaconAccountRiskEvaluateAccountAttributes.plaidNonOauthAuthenticationAttemptsCount3d) && Objects.equals(this.failedPlaidNonOauthAuthenticationAttemptsCount7d, beaconAccountRiskEvaluateAccountAttributes.failedPlaidNonOauthAuthenticationAttemptsCount7d) && Objects.equals(this.plaidNonOauthAuthenticationAttemptsCount7d, beaconAccountRiskEvaluateAccountAttributes.plaidNonOauthAuthenticationAttemptsCount7d) && Objects.equals(this.failedPlaidNonOauthAuthenticationAttemptsCount30d, beaconAccountRiskEvaluateAccountAttributes.failedPlaidNonOauthAuthenticationAttemptsCount30d) && Objects.equals(this.plaidNonOauthAuthenticationAttemptsCount30d, beaconAccountRiskEvaluateAccountAttributes.plaidNonOauthAuthenticationAttemptsCount30d) && Objects.equals(this.distinctIpAddressesCount3d, beaconAccountRiskEvaluateAccountAttributes.distinctIpAddressesCount3d) && Objects.equals(this.distinctIpAddressesCount7d, beaconAccountRiskEvaluateAccountAttributes.distinctIpAddressesCount7d) && Objects.equals(this.distinctIpAddressesCount30d, beaconAccountRiskEvaluateAccountAttributes.distinctIpAddressesCount30d) && Objects.equals(this.distinctIpAddressesCount90d, beaconAccountRiskEvaluateAccountAttributes.distinctIpAddressesCount90d) && Objects.equals(this.distinctUserAgentsCount3d, beaconAccountRiskEvaluateAccountAttributes.distinctUserAgentsCount3d) && Objects.equals(this.distinctUserAgentsCount7d, beaconAccountRiskEvaluateAccountAttributes.distinctUserAgentsCount7d) && Objects.equals(this.distinctUserAgentsCount30d, beaconAccountRiskEvaluateAccountAttributes.distinctUserAgentsCount30d) && Objects.equals(this.distinctUserAgentsCount90d, beaconAccountRiskEvaluateAccountAttributes.distinctUserAgentsCount90d) && Objects.equals(this.addressChangeCount28d, beaconAccountRiskEvaluateAccountAttributes.addressChangeCount28d) && Objects.equals(this.emailChangeCount28d, beaconAccountRiskEvaluateAccountAttributes.emailChangeCount28d) && Objects.equals(this.phoneChangeCount28d, beaconAccountRiskEvaluateAccountAttributes.phoneChangeCount28d) && Objects.equals(this.addressChangeCount90d, beaconAccountRiskEvaluateAccountAttributes.addressChangeCount90d) && Objects.equals(this.emailChangeCount90d, beaconAccountRiskEvaluateAccountAttributes.emailChangeCount90d) && Objects.equals(this.phoneChangeCount90d, beaconAccountRiskEvaluateAccountAttributes.phoneChangeCount90d) && Objects.equals(this.daysSinceAccountOpening, beaconAccountRiskEvaluateAccountAttributes.daysSinceAccountOpening) && Objects.equals(this.daysSinceFirstObservedTransaction, beaconAccountRiskEvaluateAccountAttributes.daysSinceFirstObservedTransaction);
    }

    public int hashCode() {
        return Objects.hash(this.daysSinceFirstPlaidConnection, this.isAccountClosed, this.isAccountFrozenOrRestricted, this.totalPlaidConnectionsCount, this.plaidConnectionsCount7d, this.plaidConnectionsCount30d, this.failedPlaidNonOauthAuthenticationAttemptsCount3d, this.plaidNonOauthAuthenticationAttemptsCount3d, this.failedPlaidNonOauthAuthenticationAttemptsCount7d, this.plaidNonOauthAuthenticationAttemptsCount7d, this.failedPlaidNonOauthAuthenticationAttemptsCount30d, this.plaidNonOauthAuthenticationAttemptsCount30d, this.distinctIpAddressesCount3d, this.distinctIpAddressesCount7d, this.distinctIpAddressesCount30d, this.distinctIpAddressesCount90d, this.distinctUserAgentsCount3d, this.distinctUserAgentsCount7d, this.distinctUserAgentsCount30d, this.distinctUserAgentsCount90d, this.addressChangeCount28d, this.emailChangeCount28d, this.phoneChangeCount28d, this.addressChangeCount90d, this.emailChangeCount90d, this.phoneChangeCount90d, this.daysSinceAccountOpening, this.daysSinceFirstObservedTransaction);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconAccountRiskEvaluateAccountAttributes {\n");
        sb.append("    daysSinceFirstPlaidConnection: ").append(this.toIndentedString(this.daysSinceFirstPlaidConnection)).append("\n");
        sb.append("    isAccountClosed: ").append(this.toIndentedString(this.isAccountClosed)).append("\n");
        sb.append("    isAccountFrozenOrRestricted: ").append(this.toIndentedString(this.isAccountFrozenOrRestricted)).append("\n");
        sb.append("    totalPlaidConnectionsCount: ").append(this.toIndentedString(this.totalPlaidConnectionsCount)).append("\n");
        sb.append("    plaidConnectionsCount7d: ").append(this.toIndentedString(this.plaidConnectionsCount7d)).append("\n");
        sb.append("    plaidConnectionsCount30d: ").append(this.toIndentedString(this.plaidConnectionsCount30d)).append("\n");
        sb.append("    failedPlaidNonOauthAuthenticationAttemptsCount3d: ").append(this.toIndentedString(this.failedPlaidNonOauthAuthenticationAttemptsCount3d)).append("\n");
        sb.append("    plaidNonOauthAuthenticationAttemptsCount3d: ").append(this.toIndentedString(this.plaidNonOauthAuthenticationAttemptsCount3d)).append("\n");
        sb.append("    failedPlaidNonOauthAuthenticationAttemptsCount7d: ").append(this.toIndentedString(this.failedPlaidNonOauthAuthenticationAttemptsCount7d)).append("\n");
        sb.append("    plaidNonOauthAuthenticationAttemptsCount7d: ").append(this.toIndentedString(this.plaidNonOauthAuthenticationAttemptsCount7d)).append("\n");
        sb.append("    failedPlaidNonOauthAuthenticationAttemptsCount30d: ").append(this.toIndentedString(this.failedPlaidNonOauthAuthenticationAttemptsCount30d)).append("\n");
        sb.append("    plaidNonOauthAuthenticationAttemptsCount30d: ").append(this.toIndentedString(this.plaidNonOauthAuthenticationAttemptsCount30d)).append("\n");
        sb.append("    distinctIpAddressesCount3d: ").append(this.toIndentedString(this.distinctIpAddressesCount3d)).append("\n");
        sb.append("    distinctIpAddressesCount7d: ").append(this.toIndentedString(this.distinctIpAddressesCount7d)).append("\n");
        sb.append("    distinctIpAddressesCount30d: ").append(this.toIndentedString(this.distinctIpAddressesCount30d)).append("\n");
        sb.append("    distinctIpAddressesCount90d: ").append(this.toIndentedString(this.distinctIpAddressesCount90d)).append("\n");
        sb.append("    distinctUserAgentsCount3d: ").append(this.toIndentedString(this.distinctUserAgentsCount3d)).append("\n");
        sb.append("    distinctUserAgentsCount7d: ").append(this.toIndentedString(this.distinctUserAgentsCount7d)).append("\n");
        sb.append("    distinctUserAgentsCount30d: ").append(this.toIndentedString(this.distinctUserAgentsCount30d)).append("\n");
        sb.append("    distinctUserAgentsCount90d: ").append(this.toIndentedString(this.distinctUserAgentsCount90d)).append("\n");
        sb.append("    addressChangeCount28d: ").append(this.toIndentedString(this.addressChangeCount28d)).append("\n");
        sb.append("    emailChangeCount28d: ").append(this.toIndentedString(this.emailChangeCount28d)).append("\n");
        sb.append("    phoneChangeCount28d: ").append(this.toIndentedString(this.phoneChangeCount28d)).append("\n");
        sb.append("    addressChangeCount90d: ").append(this.toIndentedString(this.addressChangeCount90d)).append("\n");
        sb.append("    emailChangeCount90d: ").append(this.toIndentedString(this.emailChangeCount90d)).append("\n");
        sb.append("    phoneChangeCount90d: ").append(this.toIndentedString(this.phoneChangeCount90d)).append("\n");
        sb.append("    daysSinceAccountOpening: ").append(this.toIndentedString(this.daysSinceAccountOpening)).append("\n");
        sb.append("    daysSinceFirstObservedTransaction: ").append(this.toIndentedString(this.daysSinceFirstObservedTransaction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

