/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountSubtype;
import com.plaid.client.model.AccountType;
import com.plaid.client.model.BeaconAccountRiskAttributes;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Bank Account Insights encapsulate the risk insights for a single Bank Account linked to an Item that is assocaited with a Beacon User.")
public class BeaconBankAccountInsights {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private AccountType type;
    public static final String SERIALIZED_NAME_SUBTYPE = "subtype";
    @SerializedName(value="subtype")
    private AccountSubtype subtype;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private BeaconAccountRiskAttributes attributes;

    public BeaconBankAccountInsights accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(example="blgvvBlXw3cq5GMPwqB6s6q4dLKB9WcVqGDGo", required=true, value="The Plaid `account_id`")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BeaconBankAccountInsights type(AccountType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AccountType getType() {
        return this.type;
    }

    public void setType(AccountType type) {
        this.type = type;
    }

    public BeaconBankAccountInsights subtype(AccountSubtype subtype) {
        this.subtype = subtype;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public AccountSubtype getSubtype() {
        return this.subtype;
    }

    public void setSubtype(AccountSubtype subtype) {
        this.subtype = subtype;
    }

    public BeaconBankAccountInsights attributes(BeaconAccountRiskAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconAccountRiskAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(BeaconAccountRiskAttributes attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconBankAccountInsights beaconBankAccountInsights = (BeaconBankAccountInsights)o;
        return Objects.equals(this.accountId, beaconBankAccountInsights.accountId) && Objects.equals((Object)this.type, (Object)beaconBankAccountInsights.type) && Objects.equals((Object)this.subtype, (Object)beaconBankAccountInsights.subtype) && Objects.equals(this.attributes, beaconBankAccountInsights.attributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.type, this.subtype, this.attributes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconBankAccountInsights {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString((Object)this.subtype)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

