/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BeaconBankAccountInsights;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A collection of Bank Accounts linked to an Item that is associated with this Beacon User.")
public class BeaconBankAccounts {
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<BeaconBankAccountInsights> accounts = new ArrayList<BeaconBankAccountInsights>();

    public BeaconBankAccounts itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(example="515cd85321d3649aecddc015", required=true, value="The Plaid Item ID the Bank Accounts belong to.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public BeaconBankAccounts accounts(List<BeaconBankAccountInsights> accounts) {
        this.accounts = accounts;
        return this;
    }

    public BeaconBankAccounts addAccountsItem(BeaconBankAccountInsights accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<BeaconBankAccountInsights> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<BeaconBankAccountInsights> accounts) {
        this.accounts = accounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconBankAccounts beaconBankAccounts = (BeaconBankAccounts)o;
        return Objects.equals(this.itemId, beaconBankAccounts.itemId) && Objects.equals(this.accounts, beaconBankAccounts.accounts);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.accounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconBankAccounts {\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

