/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Fired when a Beacon User created within your organization matches one of your existing users.")
public class BeaconDuplicateDetectedWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_BEACON_DUPLICATE_ID = "beacon_duplicate_id";
    @SerializedName(value="beacon_duplicate_id")
    private String beaconDuplicateId;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public BeaconDuplicateDetectedWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`BEACON`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public BeaconDuplicateDetectedWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`DUPLICATE_DETECTED`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public BeaconDuplicateDetectedWebhook beaconDuplicateId(String beaconDuplicateId) {
        this.beaconDuplicateId = beaconDuplicateId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the associated Beacon Duplicate.")
    public String getBeaconDuplicateId() {
        return this.beaconDuplicateId;
    }

    public void setBeaconDuplicateId(String beaconDuplicateId) {
        this.beaconDuplicateId = beaconDuplicateId;
    }

    public BeaconDuplicateDetectedWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconDuplicateDetectedWebhook beaconDuplicateDetectedWebhook = (BeaconDuplicateDetectedWebhook)o;
        return Objects.equals(this.webhookType, beaconDuplicateDetectedWebhook.webhookType) && Objects.equals(this.webhookCode, beaconDuplicateDetectedWebhook.webhookCode) && Objects.equals(this.beaconDuplicateId, beaconDuplicateDetectedWebhook.beaconDuplicateId) && Objects.equals((Object)this.environment, (Object)beaconDuplicateDetectedWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.beaconDuplicateId, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconDuplicateDetectedWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    beaconDuplicateId: ").append(this.toIndentedString(this.beaconDuplicateId)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

