/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BeaconMatchSummaryAnalysis;
import com.plaid.client.model.BeaconUserRevision;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A Beacon Duplicate represents a pair of matching Beacon Users and an analysis of the fields they matched on.")
public class BeaconDuplicateGetResponse {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_BEACON_USER1 = "beacon_user1";
    @SerializedName(value="beacon_user1")
    private BeaconUserRevision beaconUser1;
    public static final String SERIALIZED_NAME_BEACON_USER2 = "beacon_user2";
    @SerializedName(value="beacon_user2")
    private BeaconUserRevision beaconUser2;
    public static final String SERIALIZED_NAME_ANALYSIS = "analysis";
    @SerializedName(value="analysis")
    private BeaconMatchSummaryAnalysis analysis;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public BeaconDuplicateGetResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="becdup_11111111111111", required=true, value="ID of the associated Beacon Duplicate.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BeaconDuplicateGetResponse beaconUser1(BeaconUserRevision beaconUser1) {
        this.beaconUser1 = beaconUser1;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconUserRevision getBeaconUser1() {
        return this.beaconUser1;
    }

    public void setBeaconUser1(BeaconUserRevision beaconUser1) {
        this.beaconUser1 = beaconUser1;
    }

    public BeaconDuplicateGetResponse beaconUser2(BeaconUserRevision beaconUser2) {
        this.beaconUser2 = beaconUser2;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconUserRevision getBeaconUser2() {
        return this.beaconUser2;
    }

    public void setBeaconUser2(BeaconUserRevision beaconUser2) {
        this.beaconUser2 = beaconUser2;
    }

    public BeaconDuplicateGetResponse analysis(BeaconMatchSummaryAnalysis analysis) {
        this.analysis = analysis;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconMatchSummaryAnalysis getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(BeaconMatchSummaryAnalysis analysis) {
        this.analysis = analysis;
    }

    public BeaconDuplicateGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconDuplicateGetResponse beaconDuplicateGetResponse = (BeaconDuplicateGetResponse)o;
        return Objects.equals(this.id, beaconDuplicateGetResponse.id) && Objects.equals(this.beaconUser1, beaconDuplicateGetResponse.beaconUser1) && Objects.equals(this.beaconUser2, beaconDuplicateGetResponse.beaconUser2) && Objects.equals(this.analysis, beaconDuplicateGetResponse.analysis) && Objects.equals(this.requestId, beaconDuplicateGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.beaconUser1, this.beaconUser2, this.analysis, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconDuplicateGetResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    beaconUser1: ").append(this.toIndentedString(this.beaconUser1)).append("\n");
        sb.append("    beaconUser2: ").append(this.toIndentedString(this.beaconUser2)).append("\n");
        sb.append("    analysis: ").append(this.toIndentedString(this.analysis)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

