/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BeaconReportType;
import com.plaid.client.model.FraudAmount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request input for creating a Beacon Report")
public class BeaconReportCreateRequest {
    public static final String SERIALIZED_NAME_BEACON_USER_ID = "beacon_user_id";
    @SerializedName(value="beacon_user_id")
    private String beaconUserId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private BeaconReportType type;
    public static final String SERIALIZED_NAME_FRAUD_DATE = "fraud_date";
    @SerializedName(value="fraud_date")
    private LocalDate fraudDate;
    public static final String SERIALIZED_NAME_FRAUD_AMOUNT = "fraud_amount";
    @SerializedName(value="fraud_amount")
    private FraudAmount fraudAmount;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;

    public BeaconReportCreateRequest beaconUserId(String beaconUserId) {
        this.beaconUserId = beaconUserId;
        return this;
    }

    @ApiModelProperty(example="becusr_42cF1MNo42r9Xj", required=true, value="ID of the associated Beacon User.")
    public String getBeaconUserId() {
        return this.beaconUserId;
    }

    public void setBeaconUserId(String beaconUserId) {
        this.beaconUserId = beaconUserId;
    }

    public BeaconReportCreateRequest type(BeaconReportType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconReportType getType() {
        return this.type;
    }

    public void setType(BeaconReportType type) {
        this.type = type;
    }

    public BeaconReportCreateRequest fraudDate(LocalDate fraudDate) {
        this.fraudDate = fraudDate;
        return this;
    }

    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", required=true, value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getFraudDate() {
        return this.fraudDate;
    }

    public void setFraudDate(LocalDate fraudDate) {
        this.fraudDate = fraudDate;
    }

    public BeaconReportCreateRequest fraudAmount(FraudAmount fraudAmount) {
        this.fraudAmount = fraudAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FraudAmount getFraudAmount() {
        return this.fraudAmount;
    }

    public void setFraudAmount(FraudAmount fraudAmount) {
        this.fraudAmount = fraudAmount;
    }

    public BeaconReportCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public BeaconReportCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconReportCreateRequest beaconReportCreateRequest = (BeaconReportCreateRequest)o;
        return Objects.equals(this.beaconUserId, beaconReportCreateRequest.beaconUserId) && Objects.equals((Object)this.type, (Object)beaconReportCreateRequest.type) && Objects.equals(this.fraudDate, beaconReportCreateRequest.fraudDate) && Objects.equals(this.fraudAmount, beaconReportCreateRequest.fraudAmount) && Objects.equals(this.clientId, beaconReportCreateRequest.clientId) && Objects.equals(this.secret, beaconReportCreateRequest.secret);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.beaconUserId, this.type, this.fraudDate, this.fraudAmount, this.clientId, this.secret});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconReportCreateRequest {\n");
        sb.append("    beaconUserId: ").append(this.toIndentedString(this.beaconUserId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    fraudDate: ").append(this.toIndentedString(this.fraudDate)).append("\n");
        sb.append("    fraudAmount: ").append(this.toIndentedString(this.fraudAmount)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

