/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BeaconAuditTrail;
import com.plaid.client.model.BeaconReportType;
import com.plaid.client.model.FraudAmount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A Beacon Report describes the type of fraud committed by a user as well as the date the fraud was committed and the total amount of money lost due to the fraud incident.  This information is used to block similar fraud attempts on your platform as well as alert other companies who screen a user with matching identity information. Other companies will not receive any new identity information, just what matched, plus information such as industry, type of fraud, and date of fraud.  You can manage your fraud reports by adding, deleting, or editing reports as you get additional information on fraudulent users.")
public class BeaconReportCreateResponse {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_BEACON_USER_ID = "beacon_user_id";
    @SerializedName(value="beacon_user_id")
    private String beaconUserId;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private Timestamp createdAt;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private BeaconReportType type;
    public static final String SERIALIZED_NAME_FRAUD_DATE = "fraud_date";
    @SerializedName(value="fraud_date")
    private LocalDate fraudDate;
    public static final String SERIALIZED_NAME_FRAUD_AMOUNT = "fraud_amount";
    @SerializedName(value="fraud_amount")
    private FraudAmount fraudAmount;
    public static final String SERIALIZED_NAME_AUDIT_TRAIL = "audit_trail";
    @SerializedName(value="audit_trail")
    private BeaconAuditTrail auditTrail;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public BeaconReportCreateResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="becrpt_11111111111111", required=true, value="ID of the associated Beacon Report.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BeaconReportCreateResponse beaconUserId(String beaconUserId) {
        this.beaconUserId = beaconUserId;
        return this;
    }

    @ApiModelProperty(example="becusr_42cF1MNo42r9Xj", required=true, value="ID of the associated Beacon User.")
    public String getBeaconUserId() {
        return this.beaconUserId;
    }

    public void setBeaconUserId(String beaconUserId) {
        this.beaconUserId = beaconUserId;
    }

    public BeaconReportCreateResponse createdAt(Timestamp createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    public BeaconReportCreateResponse type(BeaconReportType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconReportType getType() {
        return this.type;
    }

    public void setType(BeaconReportType type) {
        this.type = type;
    }

    public BeaconReportCreateResponse fraudDate(LocalDate fraudDate) {
        this.fraudDate = fraudDate;
        return this;
    }

    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", required=true, value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getFraudDate() {
        return this.fraudDate;
    }

    public void setFraudDate(LocalDate fraudDate) {
        this.fraudDate = fraudDate;
    }

    public BeaconReportCreateResponse fraudAmount(FraudAmount fraudAmount) {
        this.fraudAmount = fraudAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public FraudAmount getFraudAmount() {
        return this.fraudAmount;
    }

    public void setFraudAmount(FraudAmount fraudAmount) {
        this.fraudAmount = fraudAmount;
    }

    public BeaconReportCreateResponse auditTrail(BeaconAuditTrail auditTrail) {
        this.auditTrail = auditTrail;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconAuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    public void setAuditTrail(BeaconAuditTrail auditTrail) {
        this.auditTrail = auditTrail;
    }

    public BeaconReportCreateResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconReportCreateResponse beaconReportCreateResponse = (BeaconReportCreateResponse)o;
        return Objects.equals(this.id, beaconReportCreateResponse.id) && Objects.equals(this.beaconUserId, beaconReportCreateResponse.beaconUserId) && Objects.equals(this.createdAt, beaconReportCreateResponse.createdAt) && Objects.equals((Object)this.type, (Object)beaconReportCreateResponse.type) && Objects.equals(this.fraudDate, beaconReportCreateResponse.fraudDate) && Objects.equals(this.fraudAmount, beaconReportCreateResponse.fraudAmount) && Objects.equals(this.auditTrail, beaconReportCreateResponse.auditTrail) && Objects.equals(this.requestId, beaconReportCreateResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.beaconUserId, this.createdAt, this.type, this.fraudDate, this.fraudAmount, this.auditTrail, this.requestId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconReportCreateResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    beaconUserId: ").append(this.toIndentedString(this.beaconUserId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    fraudDate: ").append(this.toIndentedString(this.fraudDate)).append("\n");
        sb.append("    fraudAmount: ").append(this.toIndentedString(this.fraudAmount)).append("\n");
        sb.append("    auditTrail: ").append(this.toIndentedString(this.auditTrail)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

