/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BeaconReportSyndicationAnalysis;
import com.plaid.client.model.BeaconReportSyndicationOriginalReport;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A Beacon Report Syndication represents a Beacon Report created either by your organization or another Beacon customer that matches a specific Beacon User you've created.  The `analysis` field in the response indicates which fields matched between the originally reported Beacon User and the Beacon User that the report was syndicated to.  The `report` field in the response contains a subset of information from the original report.")
public class BeaconReportSyndication {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_REPORT = "report";
    @SerializedName(value="report")
    private BeaconReportSyndicationOriginalReport report;
    public static final String SERIALIZED_NAME_ANALYSIS = "analysis";
    @SerializedName(value="analysis")
    private BeaconReportSyndicationAnalysis analysis;

    public BeaconReportSyndication id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="becrsn_11111111111111", required=true, value="ID of the associated Beacon Report Syndication.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BeaconReportSyndication report(BeaconReportSyndicationOriginalReport report) {
        this.report = report;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconReportSyndicationOriginalReport getReport() {
        return this.report;
    }

    public void setReport(BeaconReportSyndicationOriginalReport report) {
        this.report = report;
    }

    public BeaconReportSyndication analysis(BeaconReportSyndicationAnalysis analysis) {
        this.analysis = analysis;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconReportSyndicationAnalysis getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(BeaconReportSyndicationAnalysis analysis) {
        this.analysis = analysis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconReportSyndication beaconReportSyndication = (BeaconReportSyndication)o;
        return Objects.equals(this.id, beaconReportSyndication.id) && Objects.equals(this.report, beaconReportSyndication.report) && Objects.equals(this.analysis, beaconReportSyndication.analysis);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.report, this.analysis);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconReportSyndication {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    report: ").append(this.toIndentedString(this.report)).append("\n");
        sb.append("    analysis: ").append(this.toIndentedString(this.analysis)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

