/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BeaconReportType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A subset of information from a Beacon Report that has been syndicated to a matching Beacon User in your program.  The `id` field in the response is the ID of the original report that was syndicated. If the original report was created by your organization, the field will be filled with the ID of the report. Otherwise, the field will be `null` indicating that the original report was created by another Beacon customer.")
public class BeaconReportSyndicationOriginalReport {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private Timestamp createdAt;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private BeaconReportType type;
    public static final String SERIALIZED_NAME_FRAUD_DATE = "fraud_date";
    @SerializedName(value="fraud_date")
    private LocalDate fraudDate;

    public BeaconReportSyndicationOriginalReport id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="becrpt_11111111111111", required=true, value="ID of the associated Beacon Report.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BeaconReportSyndicationOriginalReport createdAt(Timestamp createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    public BeaconReportSyndicationOriginalReport type(BeaconReportType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconReportType getType() {
        return this.type;
    }

    public void setType(BeaconReportType type) {
        this.type = type;
    }

    public BeaconReportSyndicationOriginalReport fraudDate(LocalDate fraudDate) {
        this.fraudDate = fraudDate;
        return this;
    }

    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", required=true, value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getFraudDate() {
        return this.fraudDate;
    }

    public void setFraudDate(LocalDate fraudDate) {
        this.fraudDate = fraudDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconReportSyndicationOriginalReport beaconReportSyndicationOriginalReport = (BeaconReportSyndicationOriginalReport)o;
        return Objects.equals(this.id, beaconReportSyndicationOriginalReport.id) && Objects.equals(this.createdAt, beaconReportSyndicationOriginalReport.createdAt) && Objects.equals((Object)this.type, (Object)beaconReportSyndicationOriginalReport.type) && Objects.equals(this.fraudDate, beaconReportSyndicationOriginalReport.fraudDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdAt, this.type, this.fraudDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconReportSyndicationOriginalReport {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    fraudDate: ").append(this.toIndentedString(this.fraudDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

