/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Fired when one of your existing Beacon Reports has been modified or removed from the Beacon Network.")
public class BeaconReportUpdatedWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_BEACON_REPORT_ID = "beacon_report_id";
    @SerializedName(value="beacon_report_id")
    private String beaconReportId;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public BeaconReportUpdatedWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`BEACON`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public BeaconReportUpdatedWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`REPORT_UPDATED`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public BeaconReportUpdatedWebhook beaconReportId(String beaconReportId) {
        this.beaconReportId = beaconReportId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the associated Beacon Report.")
    public String getBeaconReportId() {
        return this.beaconReportId;
    }

    public void setBeaconReportId(String beaconReportId) {
        this.beaconReportId = beaconReportId;
    }

    public BeaconReportUpdatedWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconReportUpdatedWebhook beaconReportUpdatedWebhook = (BeaconReportUpdatedWebhook)o;
        return Objects.equals(this.webhookType, beaconReportUpdatedWebhook.webhookType) && Objects.equals(this.webhookCode, beaconReportUpdatedWebhook.webhookCode) && Objects.equals(this.beaconReportId, beaconReportUpdatedWebhook.beaconReportId) && Objects.equals((Object)this.environment, (Object)beaconReportUpdatedWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.beaconReportId, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconReportUpdatedWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    beaconReportId: ").append(this.toIndentedString(this.beaconReportId)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

