/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request input for fetching the risk insights for a Beacon User's Bank Accounts")
public class BeaconUserAccountInsightsGetRequest {
    public static final String SERIALIZED_NAME_BEACON_USER_ID = "beacon_user_id";
    @SerializedName(value="beacon_user_id")
    private String beaconUserId;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;

    public BeaconUserAccountInsightsGetRequest beaconUserId(String beaconUserId) {
        this.beaconUserId = beaconUserId;
        return this;
    }

    @ApiModelProperty(example="becusr_42cF1MNo42r9Xj", required=true, value="ID of the associated Beacon User.")
    public String getBeaconUserId() {
        return this.beaconUserId;
    }

    public void setBeaconUserId(String beaconUserId) {
        this.beaconUserId = beaconUserId;
    }

    public BeaconUserAccountInsightsGetRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public BeaconUserAccountInsightsGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public BeaconUserAccountInsightsGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconUserAccountInsightsGetRequest beaconUserAccountInsightsGetRequest = (BeaconUserAccountInsightsGetRequest)o;
        return Objects.equals(this.beaconUserId, beaconUserAccountInsightsGetRequest.beaconUserId) && Objects.equals(this.accessToken, beaconUserAccountInsightsGetRequest.accessToken) && Objects.equals(this.clientId, beaconUserAccountInsightsGetRequest.clientId) && Objects.equals(this.secret, beaconUserAccountInsightsGetRequest.secret);
    }

    public int hashCode() {
        return Objects.hash(this.beaconUserId, this.accessToken, this.clientId, this.secret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconUserAccountInsightsGetRequest {\n");
        sb.append("    beaconUserId: ").append(this.toIndentedString(this.beaconUserId)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

