/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BeaconUserRequestData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request input for creating a Beacon User.  The primary use for this endpoint is to add a new end user to Beacon for fraud and duplicate scanning.  Some fields are optional, but it is recommended to provide as much information as possible to improve the accuracy of the fraud and duplicate scanning.")
public class BeaconUserCreateRequest {
    public static final String SERIALIZED_NAME_PROGRAM_ID = "program_id";
    @SerializedName(value="program_id")
    private String programId;
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private BeaconUserRequestData user;
    public static final String SERIALIZED_NAME_ACCESS_TOKENS = "access_tokens";
    @SerializedName(value="access_tokens")
    private List<String> accessTokens = null;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;

    public BeaconUserCreateRequest programId(String programId) {
        this.programId = programId;
        return this;
    }

    @ApiModelProperty(example="becprg_11111111111111", required=true, value="ID of the associated Beacon Program.")
    public String getProgramId() {
        return this.programId;
    }

    public void setProgramId(String programId) {
        this.programId = programId;
    }

    public BeaconUserCreateRequest clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @ApiModelProperty(example="your-db-id-3b24110", required=true, value="A unique ID that identifies the end user in your system. This ID can also be used to associate user-specific data from other Plaid products. Financial Account Matching requires this field and the `/link/token/create` `client_user_id` to be consistent. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public BeaconUserCreateRequest user(BeaconUserRequestData user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconUserRequestData getUser() {
        return this.user;
    }

    public void setUser(BeaconUserRequestData user) {
        this.user = user;
    }

    public BeaconUserCreateRequest accessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
        return this;
    }

    public BeaconUserCreateRequest addAccessTokensItem(String accessTokensItem) {
        if (this.accessTokens == null) {
            this.accessTokens = new ArrayList<String>();
        }
        this.accessTokens.add(accessTokensItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Send this array of access tokens to link accounts to the Beacon User and have them evaluated for Account Insights.  A maximum of 50 accounts total can be added to a single Beacon User.")
    public List<String> getAccessTokens() {
        return this.accessTokens;
    }

    public void setAccessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
    }

    public BeaconUserCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public BeaconUserCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconUserCreateRequest beaconUserCreateRequest = (BeaconUserCreateRequest)o;
        return Objects.equals(this.programId, beaconUserCreateRequest.programId) && Objects.equals(this.clientUserId, beaconUserCreateRequest.clientUserId) && Objects.equals(this.user, beaconUserCreateRequest.user) && Objects.equals(this.accessTokens, beaconUserCreateRequest.accessTokens) && Objects.equals(this.clientId, beaconUserCreateRequest.clientId) && Objects.equals(this.secret, beaconUserCreateRequest.secret);
    }

    public int hashCode() {
        return Objects.hash(this.programId, this.clientUserId, this.user, this.accessTokens, this.clientId, this.secret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconUserCreateRequest {\n");
        sb.append("    programId: ").append(this.toIndentedString(this.programId)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    accessTokens: ").append(this.toIndentedString(this.accessTokens)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

