/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Home address for the associated user. For more context on this field, see [Input Validation by Country](https://plaid.com/docs/identity-verification/hybrid-input-validation/#input-validation-by-country).")
public class BeaconUserRequestAddress {
    public static final String SERIALIZED_NAME_STREET = "street";
    @SerializedName(value="street")
    private String street;
    public static final String SERIALIZED_NAME_STREET2 = "street2";
    @SerializedName(value="street2")
    private String street2;
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private String region;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;

    public BeaconUserRequestAddress street(String street) {
        this.street = street;
        return this;
    }

    @ApiModelProperty(example="123 Main St.", required=true, value="The primary street portion of an address. If an address is provided, this field will always be filled. A string with at least one non-whitespace alphabetical character, with a max length of 80 characters.")
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public BeaconUserRequestAddress street2(String street2) {
        this.street2 = street2;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Unit 42", value="Extra street information, like an apartment or suite number. If provided, a string with at least one non-whitespace character, with a max length of 20 characters.")
    public String getStreet2() {
        return this.street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public BeaconUserRequestAddress city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(example="Pawnee", required=true, value="City from the end user's address. A string with at least one non-whitespace alphabetical character, with a max length of 100 characters.\"")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public BeaconUserRequestAddress region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="IN", value="An ISO 3166-2 subdivision code. Related terms would be \"state\", \"province\", \"prefecture\", \"zone\", \"subdivision\", etc.")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public BeaconUserRequestAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="46001", value="The postal code for the associated address. Between 2 and 10 alphanumeric characters. For US-based addresses this must be 5 numeric digits.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public BeaconUserRequestAddress country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(example="US", required=true, value="Valid, capitalized, two-letter ISO code representing the country of this object. Must be in ISO 3166-1 alpha-2 form.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconUserRequestAddress beaconUserRequestAddress = (BeaconUserRequestAddress)o;
        return Objects.equals(this.street, beaconUserRequestAddress.street) && Objects.equals(this.street2, beaconUserRequestAddress.street2) && Objects.equals(this.city, beaconUserRequestAddress.city) && Objects.equals(this.region, beaconUserRequestAddress.region) && Objects.equals(this.postalCode, beaconUserRequestAddress.postalCode) && Objects.equals(this.country, beaconUserRequestAddress.country);
    }

    public int hashCode() {
        return Objects.hash(this.street, this.street2, this.city, this.region, this.postalCode, this.country);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconUserRequestAddress {\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    street2: ").append(this.toIndentedString(this.street2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

