/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A Beacon User Revision identifies a Beacon User at some point in its revision history.")
public class BeaconUserRevision {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;

    public BeaconUserRevision id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="becusr_42cF1MNo42r9Xj", required=true, value="ID of the associated Beacon User.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BeaconUserRevision version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="The `version` field begins with 1 and increments with each subsequent revision.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconUserRevision beaconUserRevision = (BeaconUserRevision)o;
        return Objects.equals(this.id, beaconUserRevision.id) && Objects.equals(this.version, beaconUserRevision.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconUserRevision {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

