/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Fired when a Beacon User status has changed, which can occur manually via the dashboard or when information is reported to the Beacon network.")
public class BeaconUserStatusUpdatedWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_BEACON_USER_ID = "beacon_user_id";
    @SerializedName(value="beacon_user_id")
    private String beaconUserId;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public BeaconUserStatusUpdatedWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`BEACON`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public BeaconUserStatusUpdatedWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`USER_STATUS_UPDATED`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public BeaconUserStatusUpdatedWebhook beaconUserId(String beaconUserId) {
        this.beaconUserId = beaconUserId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the associated Beacon user.")
    public String getBeaconUserId() {
        return this.beaconUserId;
    }

    public void setBeaconUserId(String beaconUserId) {
        this.beaconUserId = beaconUserId;
    }

    public BeaconUserStatusUpdatedWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconUserStatusUpdatedWebhook beaconUserStatusUpdatedWebhook = (BeaconUserStatusUpdatedWebhook)o;
        return Objects.equals(this.webhookType, beaconUserStatusUpdatedWebhook.webhookType) && Objects.equals(this.webhookCode, beaconUserStatusUpdatedWebhook.webhookCode) && Objects.equals(this.beaconUserId, beaconUserStatusUpdatedWebhook.beaconUserId) && Objects.equals((Object)this.environment, (Object)beaconUserStatusUpdatedWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.beaconUserId, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconUserStatusUpdatedWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    beaconUserId: ").append(this.toIndentedString(this.beaconUserId)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

