/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BeaconUserUpdateRequestData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request input for updating the identity data of a Beacon User.")
public class BeaconUserUpdateRequest {
    public static final String SERIALIZED_NAME_BEACON_USER_ID = "beacon_user_id";
    @SerializedName(value="beacon_user_id")
    private String beaconUserId;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private BeaconUserUpdateRequestData user;
    public static final String SERIALIZED_NAME_ACCESS_TOKENS = "access_tokens";
    @SerializedName(value="access_tokens")
    private List<String> accessTokens = null;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;

    public BeaconUserUpdateRequest beaconUserId(String beaconUserId) {
        this.beaconUserId = beaconUserId;
        return this;
    }

    @ApiModelProperty(example="becusr_42cF1MNo42r9Xj", required=true, value="ID of the associated Beacon User.")
    public String getBeaconUserId() {
        return this.beaconUserId;
    }

    public void setBeaconUserId(String beaconUserId) {
        this.beaconUserId = beaconUserId;
    }

    public BeaconUserUpdateRequest user(BeaconUserUpdateRequestData user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BeaconUserUpdateRequestData getUser() {
        return this.user;
    }

    public void setUser(BeaconUserUpdateRequestData user) {
        this.user = user;
    }

    public BeaconUserUpdateRequest accessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
        return this;
    }

    public BeaconUserUpdateRequest addAccessTokensItem(String accessTokensItem) {
        if (this.accessTokens == null) {
            this.accessTokens = new ArrayList<String>();
        }
        this.accessTokens.add(accessTokensItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Send this array of access tokens to add accounts to this user for evaluation. This will add accounts to this Beacon User. If left null only existing accounts will be returned in response. A maximum of 50 accounts total can be added to a Beacon User.")
    public List<String> getAccessTokens() {
        return this.accessTokens;
    }

    public void setAccessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
    }

    public BeaconUserUpdateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public BeaconUserUpdateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconUserUpdateRequest beaconUserUpdateRequest = (BeaconUserUpdateRequest)o;
        return Objects.equals(this.beaconUserId, beaconUserUpdateRequest.beaconUserId) && Objects.equals(this.user, beaconUserUpdateRequest.user) && Objects.equals(this.accessTokens, beaconUserUpdateRequest.accessTokens) && Objects.equals(this.clientId, beaconUserUpdateRequest.clientId) && Objects.equals(this.secret, beaconUserUpdateRequest.secret);
    }

    public int hashCode() {
        return Objects.hash(this.beaconUserId, this.user, this.accessTokens, this.clientId, this.secret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconUserUpdateRequest {\n");
        sb.append("    beaconUserId: ").append(this.toIndentedString(this.beaconUserId)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    accessTokens: ").append(this.toIndentedString(this.accessTokens)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

