/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BeaconUserIDNumber;
import com.plaid.client.model.BeaconUserNameNullable;
import com.plaid.client.model.BeaconUserRequestAddressNullable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A subset of a Beacon User's data which is used to patch the existing identity data associated with a Beacon User. At least one field must be provided. If left unset or null, user data will not be patched.")
public class BeaconUserUpdateRequestData {
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
    @SerializedName(value="date_of_birth")
    private LocalDate dateOfBirth;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private BeaconUserNameNullable name;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private BeaconUserRequestAddressNullable address;
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "email_address";
    @SerializedName(value="email_address")
    private String emailAddress;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phone_number";
    @SerializedName(value="phone_number")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_ID_NUMBER = "id_number";
    @SerializedName(value="id_number")
    private BeaconUserIDNumber idNumber;
    public static final String SERIALIZED_NAME_IP_ADDRESS = "ip_address";
    @SerializedName(value="ip_address")
    private String ipAddress;

    public BeaconUserUpdateRequestData dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public BeaconUserUpdateRequestData name(BeaconUserNameNullable name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BeaconUserNameNullable getName() {
        return this.name;
    }

    public void setName(BeaconUserNameNullable name) {
        this.name = name;
    }

    public BeaconUserUpdateRequestData address(BeaconUserRequestAddressNullable address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BeaconUserRequestAddressNullable getAddress() {
        return this.address;
    }

    public void setAddress(BeaconUserRequestAddressNullable address) {
        this.address = address;
    }

    public BeaconUserUpdateRequestData emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user@example.com", value="A valid email address.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public BeaconUserUpdateRequestData phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="+19876543212", value="A phone number in E.164 format.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public BeaconUserUpdateRequestData idNumber(BeaconUserIDNumber idNumber) {
        this.idNumber = idNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BeaconUserIDNumber getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(BeaconUserIDNumber idNumber) {
        this.idNumber = idNumber;
    }

    public BeaconUserUpdateRequestData ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="192.0.2.42", value="An IPv4 or IPV6 address.")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconUserUpdateRequestData beaconUserUpdateRequestData = (BeaconUserUpdateRequestData)o;
        return Objects.equals(this.dateOfBirth, beaconUserUpdateRequestData.dateOfBirth) && Objects.equals(this.name, beaconUserUpdateRequestData.name) && Objects.equals(this.address, beaconUserUpdateRequestData.address) && Objects.equals(this.emailAddress, beaconUserUpdateRequestData.emailAddress) && Objects.equals(this.phoneNumber, beaconUserUpdateRequestData.phoneNumber) && Objects.equals(this.idNumber, beaconUserUpdateRequestData.idNumber) && Objects.equals(this.ipAddress, beaconUserUpdateRequestData.ipAddress);
    }

    public int hashCode() {
        return Objects.hash(this.dateOfBirth, this.name, this.address, this.emailAddress, this.phoneNumber, this.idNumber, this.ipAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconUserUpdateRequestData {\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    idNumber: ").append(this.toIndentedString(this.idNumber)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

