/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BeaconAuditTrail;
import com.plaid.client.model.BeaconUserData;
import com.plaid.client.model.BeaconUserStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="A Beacon User represents an end user that has been scanned against the Beacon Network.")
public class BeaconUserUpdateResponse {
    public static final String SERIALIZED_NAME_ITEM_IDS = "item_ids";
    @SerializedName(value="item_ids")
    private Set<String> itemIds = new LinkedHashSet<String>();
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private Timestamp createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private BeaconUserStatus status;
    public static final String SERIALIZED_NAME_PROGRAM_ID = "program_id";
    @SerializedName(value="program_id")
    private String programId;
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private BeaconUserData user;
    public static final String SERIALIZED_NAME_AUDIT_TRAIL = "audit_trail";
    @SerializedName(value="audit_trail")
    private BeaconAuditTrail auditTrail;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public BeaconUserUpdateResponse itemIds(Set<String> itemIds) {
        this.itemIds = itemIds;
        return this;
    }

    public BeaconUserUpdateResponse addItemIdsItem(String itemIdsItem) {
        this.itemIds.add(itemIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"515cd85321d3649aecddc015\"]", required=true, value="An array of Plaid Item IDs corresponding to the Accounts associated with this Beacon User.")
    public Set<String> getItemIds() {
        return this.itemIds;
    }

    public void setItemIds(Set<String> itemIds) {
        this.itemIds = itemIds;
    }

    public BeaconUserUpdateResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="becusr_42cF1MNo42r9Xj", required=true, value="ID of the associated Beacon User.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BeaconUserUpdateResponse version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="The `version` field begins with 1 and increments each time the user is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public BeaconUserUpdateResponse createdAt(Timestamp createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    public BeaconUserUpdateResponse updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(example="2020-07-24T03:26:02Z", required=true, value="An ISO8601 formatted timestamp. This field indicates the last time the resource was modified.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public BeaconUserUpdateResponse status(BeaconUserStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconUserStatus getStatus() {
        return this.status;
    }

    public void setStatus(BeaconUserStatus status) {
        this.status = status;
    }

    public BeaconUserUpdateResponse programId(String programId) {
        this.programId = programId;
        return this;
    }

    @ApiModelProperty(example="becprg_11111111111111", required=true, value="ID of the associated Beacon Program.")
    public String getProgramId() {
        return this.programId;
    }

    public void setProgramId(String programId) {
        this.programId = programId;
    }

    public BeaconUserUpdateResponse clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @ApiModelProperty(example="your-db-id-3b24110", required=true, value="A unique ID that identifies the end user in your system. This ID can also be used to associate user-specific data from other Plaid products. Financial Account Matching requires this field and the `/link/token/create` `client_user_id` to be consistent. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public BeaconUserUpdateResponse user(BeaconUserData user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconUserData getUser() {
        return this.user;
    }

    public void setUser(BeaconUserData user) {
        this.user = user;
    }

    public BeaconUserUpdateResponse auditTrail(BeaconAuditTrail auditTrail) {
        this.auditTrail = auditTrail;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BeaconAuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    public void setAuditTrail(BeaconAuditTrail auditTrail) {
        this.auditTrail = auditTrail;
    }

    public BeaconUserUpdateResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconUserUpdateResponse beaconUserUpdateResponse = (BeaconUserUpdateResponse)o;
        return Objects.equals(this.itemIds, beaconUserUpdateResponse.itemIds) && Objects.equals(this.id, beaconUserUpdateResponse.id) && Objects.equals(this.version, beaconUserUpdateResponse.version) && Objects.equals(this.createdAt, beaconUserUpdateResponse.createdAt) && Objects.equals(this.updatedAt, beaconUserUpdateResponse.updatedAt) && Objects.equals((Object)this.status, (Object)beaconUserUpdateResponse.status) && Objects.equals(this.programId, beaconUserUpdateResponse.programId) && Objects.equals(this.clientUserId, beaconUserUpdateResponse.clientUserId) && Objects.equals(this.user, beaconUserUpdateResponse.user) && Objects.equals(this.auditTrail, beaconUserUpdateResponse.auditTrail) && Objects.equals(this.requestId, beaconUserUpdateResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.itemIds, this.id, this.version, this.createdAt, this.updatedAt, this.status, this.programId, this.clientUserId, this.user, this.auditTrail, this.requestId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeaconUserUpdateResponse {\n");
        sb.append("    itemIds: ").append(this.toIndentedString(this.itemIds)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    programId: ").append(this.toIndentedString(this.programId)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    auditTrail: ").append(this.toIndentedString(this.auditTrail)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

