/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CraLoanRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CraLoansRegisterRequest defines the request schema for `/cra/loans/register`")
public class CRALoansRegisterRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_LOANS = "loans";
    @SerializedName(value="loans")
    private List<CraLoanRegister> loans = new ArrayList<CraLoanRegister>();

    public CRALoansRegisterRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CRALoansRegisterRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CRALoansRegisterRequest loans(List<CraLoanRegister> loans) {
        this.loans = loans;
        return this;
    }

    public CRALoansRegisterRequest addLoansItem(CraLoanRegister loansItem) {
        this.loans.add(loansItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of loans to register.")
    public List<CraLoanRegister> getLoans() {
        return this.loans;
    }

    public void setLoans(List<CraLoanRegister> loans) {
        this.loans = loans;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CRALoansRegisterRequest crALoansRegisterRequest = (CRALoansRegisterRequest)o;
        return Objects.equals(this.clientId, crALoansRegisterRequest.clientId) && Objects.equals(this.secret, crALoansRegisterRequest.secret) && Objects.equals(this.loans, crALoansRegisterRequest.loans);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.loans);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CRALoansRegisterRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    loans: ").append(this.toIndentedString(this.loans)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

