/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Category;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="CategoriesGetResponse defines the response schema for `/categories/get`")
public class CategoriesGetResponse {
    public static final String SERIALIZED_NAME_CATEGORIES = "categories";
    @SerializedName(value="categories")
    private List<Category> categories = new ArrayList<Category>();
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public CategoriesGetResponse categories(List<Category> categories) {
        this.categories = categories;
        return this;
    }

    public CategoriesGetResponse addCategoriesItem(Category categoriesItem) {
        this.categories.add(categoriesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of all of the transaction categories used by Plaid.")
    public List<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public CategoriesGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoriesGetResponse categoriesGetResponse = (CategoriesGetResponse)o;
        return Objects.equals(this.categories, categoriesGetResponse.categories) && Objects.equals(this.requestId, categoriesGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.categories, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CategoriesGetResponse {\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

