/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Information describing a transaction category")
public class Category {
    public static final String SERIALIZED_NAME_CATEGORY_ID = "category_id";
    @SerializedName(value="category_id")
    private String categoryId;
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private String group;
    public static final String SERIALIZED_NAME_HIERARCHY = "hierarchy";
    @SerializedName(value="hierarchy")
    private List<String> hierarchy = new ArrayList<String>();

    public Category categoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @ApiModelProperty(required=true, value="An identifying number for the category. `category_id` is a Plaid-specific identifier and does not necessarily correspond to merchant category codes.")
    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public Category group(String group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(required=true, value="`place` for physical transactions or `special` for other transactions such as bank charges.")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Category hierarchy(List<String> hierarchy) {
        this.hierarchy = hierarchy;
        return this;
    }

    public Category addHierarchyItem(String hierarchyItem) {
        this.hierarchy.add(hierarchyItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A hierarchical array of the categories to which this `category_id` belongs.")
    public List<String> getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(List<String> hierarchy) {
        this.hierarchy = hierarchy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Category category = (Category)o;
        return Objects.equals(this.categoryId, category.categoryId) && Objects.equals(this.group, category.group) && Objects.equals(this.hierarchy, category.hierarchy);
    }

    public int hashCode() {
        return Objects.hash(this.categoryId, this.group, this.hierarchy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Category {\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    hierarchy: ").append(this.toIndentedString(this.hierarchy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

