/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Insights object for categories.")
public class CategoryInsightDetails {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TRANSACTION_COUNT = "transaction_count";
    @SerializedName(value="transaction_count")
    private Integer transactionCount;
    public static final String SERIALIZED_NAME_TOTAL_OUTFLOWS = "total_outflows";
    @SerializedName(value="total_outflows")
    private Double totalOutflows;
    public static final String SERIALIZED_NAME_TOTAL_INFLOWS = "total_inflows";
    @SerializedName(value="total_inflows")
    private Double totalInflows;
    public static final String SERIALIZED_NAME_TOP_COUNTERPARTIES = "top_counterparties";
    @SerializedName(value="top_counterparties")
    private List<String> topCounterparties = null;

    public CategoryInsightDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Category name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CategoryInsightDetails transactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of transactions associated with this category.")
    public Integer getTransactionCount() {
        return this.transactionCount;
    }

    public void setTransactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
    }

    public CategoryInsightDetails totalOutflows(Double totalOutflows) {
        this.totalOutflows = totalOutflows;
        return this;
    }

    @ApiModelProperty(required=true, value="Sum of outflow amounts.")
    public Double getTotalOutflows() {
        return this.totalOutflows;
    }

    public void setTotalOutflows(Double totalOutflows) {
        this.totalOutflows = totalOutflows;
    }

    public CategoryInsightDetails totalInflows(Double totalInflows) {
        this.totalInflows = totalInflows;
        return this;
    }

    @ApiModelProperty(required=true, value="Sum of inflow amounts.")
    public Double getTotalInflows() {
        return this.totalInflows;
    }

    public void setTotalInflows(Double totalInflows) {
        this.totalInflows = totalInflows;
    }

    public CategoryInsightDetails topCounterparties(List<String> topCounterparties) {
        this.topCounterparties = topCounterparties;
        return this;
    }

    public CategoryInsightDetails addTopCounterpartiesItem(String topCounterpartiesItem) {
        if (this.topCounterparties == null) {
            this.topCounterparties = new ArrayList<String>();
        }
        this.topCounterparties.add(topCounterpartiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The most common counterparties associated with this category sorted by outflow.")
    public List<String> getTopCounterparties() {
        return this.topCounterparties;
    }

    public void setTopCounterparties(List<String> topCounterparties) {
        this.topCounterparties = topCounterparties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryInsightDetails categoryInsightDetails = (CategoryInsightDetails)o;
        return Objects.equals(this.name, categoryInsightDetails.name) && Objects.equals(this.transactionCount, categoryInsightDetails.transactionCount) && Objects.equals(this.totalOutflows, categoryInsightDetails.totalOutflows) && Objects.equals(this.totalInflows, categoryInsightDetails.totalInflows) && Objects.equals(this.topCounterparties, categoryInsightDetails.topCounterparties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.transactionCount, this.totalOutflows, this.totalInflows, this.topCounterparties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CategoryInsightDetails {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    transactionCount: ").append(this.toIndentedString(this.transactionCount)).append("\n");
        sb.append("    totalOutflows: ").append(this.toIndentedString(this.totalOutflows)).append("\n");
        sb.append("    totalInflows: ").append(this.toIndentedString(this.totalInflows)).append("\n");
        sb.append("    topCounterparties: ").append(this.toIndentedString(this.topCounterparties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

