/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CategoryInsightDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Insights on a user's top personal finance categories.")
public class CategoryInsights {
    public static final String SERIALIZED_NAME_PRIMARY_CATEGORY_INSIGHTS = "primary_category_insights";
    @SerializedName(value="primary_category_insights")
    private List<CategoryInsightDetails> primaryCategoryInsights = null;
    public static final String SERIALIZED_NAME_DETAILED_CATEGORY_INSIGHTS = "detailed_category_insights";
    @SerializedName(value="detailed_category_insights")
    private List<CategoryInsightDetails> detailedCategoryInsights = null;

    public CategoryInsights primaryCategoryInsights(List<CategoryInsightDetails> primaryCategoryInsights) {
        this.primaryCategoryInsights = primaryCategoryInsights;
        return this;
    }

    public CategoryInsights addPrimaryCategoryInsightsItem(CategoryInsightDetails primaryCategoryInsightsItem) {
        if (this.primaryCategoryInsights == null) {
            this.primaryCategoryInsights = new ArrayList<CategoryInsightDetails>();
        }
        this.primaryCategoryInsights.add(primaryCategoryInsightsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of insights of top primary personal finance categories ranked by outflow.")
    public List<CategoryInsightDetails> getPrimaryCategoryInsights() {
        return this.primaryCategoryInsights;
    }

    public void setPrimaryCategoryInsights(List<CategoryInsightDetails> primaryCategoryInsights) {
        this.primaryCategoryInsights = primaryCategoryInsights;
    }

    public CategoryInsights detailedCategoryInsights(List<CategoryInsightDetails> detailedCategoryInsights) {
        this.detailedCategoryInsights = detailedCategoryInsights;
        return this;
    }

    public CategoryInsights addDetailedCategoryInsightsItem(CategoryInsightDetails detailedCategoryInsightsItem) {
        if (this.detailedCategoryInsights == null) {
            this.detailedCategoryInsights = new ArrayList<CategoryInsightDetails>();
        }
        this.detailedCategoryInsights.add(detailedCategoryInsightsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of insights of top detailed personal finance categories ranked by outflow.")
    public List<CategoryInsightDetails> getDetailedCategoryInsights() {
        return this.detailedCategoryInsights;
    }

    public void setDetailedCategoryInsights(List<CategoryInsightDetails> detailedCategoryInsights) {
        this.detailedCategoryInsights = detailedCategoryInsights;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryInsights categoryInsights = (CategoryInsights)o;
        return Objects.equals(this.primaryCategoryInsights, categoryInsights.primaryCategoryInsights) && Objects.equals(this.detailedCategoryInsights, categoryInsights.detailedCategoryInsights);
    }

    public int hashCode() {
        return Objects.hash(this.primaryCategoryInsights, this.detailedCategoryInsights);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CategoryInsights {\n");
        sb.append("    primaryCategoryInsights: ").append(this.toIndentedString(this.primaryCategoryInsights)).append("\n");
        sb.append("    detailedCategoryInsights: ").append(this.toIndentedString(this.detailedCategoryInsights)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

