/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Enhancements;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A client-provided transaction that Plaid has enhanced.")
public class ClientProvidedEnhancedTransaction {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_ENHANCEMENTS = "enhancements";
    @SerializedName(value="enhancements")
    private Enhancements enhancements;

    public ClientProvidedEnhancedTransaction id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique transaction identifier to tie transactions back to clients' systems.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ClientProvidedEnhancedTransaction description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The raw description of the transaction.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ClientProvidedEnhancedTransaction amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The value of the transaction, denominated in the account's currency, as stated in `iso_currency_code`. Positive values when money moves out of the account; negative values when money moves in. For example, debit card purchases are positive; credit card payments, direct deposits, and refunds are negative.")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public ClientProvidedEnhancedTransaction isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the transaction.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public ClientProvidedEnhancedTransaction enhancements(Enhancements enhancements) {
        this.enhancements = enhancements;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Enhancements getEnhancements() {
        return this.enhancements;
    }

    public void setEnhancements(Enhancements enhancements) {
        this.enhancements = enhancements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientProvidedEnhancedTransaction clientProvidedEnhancedTransaction = (ClientProvidedEnhancedTransaction)o;
        return Objects.equals(this.id, clientProvidedEnhancedTransaction.id) && Objects.equals(this.description, clientProvidedEnhancedTransaction.description) && Objects.equals(this.amount, clientProvidedEnhancedTransaction.amount) && Objects.equals(this.isoCurrencyCode, clientProvidedEnhancedTransaction.isoCurrencyCode) && Objects.equals(this.enhancements, clientProvidedEnhancedTransaction.enhancements);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.amount, this.isoCurrencyCode, this.enhancements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClientProvidedEnhancedTransaction {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    enhancements: ").append(this.toIndentedString(this.enhancements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

