/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ClientProvidedTransactionLocation;
import com.plaid.client.model.EnrichTransactionDirection;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A client-provided transaction for Plaid to enrich.")
public class ClientProvidedTransaction {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_CLIENT_ACCOUNT_ID = "client_account_id";
    @SerializedName(value="client_account_id")
    private String clientAccountId;
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "account_type";
    @SerializedName(value="account_type")
    private String accountType;
    public static final String SERIALIZED_NAME_ACCOUNT_SUBTYPE = "account_subtype";
    @SerializedName(value="account_subtype")
    private String accountSubtype;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private EnrichTransactionDirection direction;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_LOCATION = "location";
    @SerializedName(value="location")
    private ClientProvidedTransactionLocation location;
    public static final String SERIALIZED_NAME_MCC = "mcc";
    @SerializedName(value="mcc")
    private String mcc;
    public static final String SERIALIZED_NAME_DATE_POSTED = "date_posted";
    @SerializedName(value="date_posted")
    private LocalDate datePosted;

    public ClientProvidedTransaction id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique ID for the transaction used to help you tie data back to your systems.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ClientProvidedTransaction clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique user id used to group transactions for a given user, as a unique identifier from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public ClientProvidedTransaction clientAccountId(String clientAccountId) {
        this.clientAccountId = clientAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique account id used to group transactions for a given account, as a unique identifier from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_account_id.")
    public String getClientAccountId() {
        return this.clientAccountId;
    }

    public void setClientAccountId(String clientAccountId) {
        this.clientAccountId = clientAccountId;
    }

    public ClientProvidedTransaction accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account type associated with the transaction. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public ClientProvidedTransaction accountSubtype(String accountSubtype) {
        this.accountSubtype = accountSubtype;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account subtype associated with the transaction. For a full list of valid types and subtypes, see the [Account schema](https://plaid.com/docs/api/accounts#account-type-schema).")
    public String getAccountSubtype() {
        return this.accountSubtype;
    }

    public void setAccountSubtype(String accountSubtype) {
        this.accountSubtype = accountSubtype;
    }

    public ClientProvidedTransaction description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The raw description of the transaction. If you have location data in available an unstructured format, it may be appended to the `description` field.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ClientProvidedTransaction amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The absolute value of the transaction (>= 0). When testing Enrich, note that `amount` data should be realistic. Unrealistic or inaccurate `amount` data may result in reduced quality output.")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public ClientProvidedTransaction direction(EnrichTransactionDirection direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public EnrichTransactionDirection getDirection() {
        return this.direction;
    }

    public void setDirection(EnrichTransactionDirection direction) {
        this.direction = direction;
    }

    public ClientProvidedTransaction isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the transaction e.g. USD.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public ClientProvidedTransaction location(ClientProvidedTransactionLocation location) {
        this.location = location;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ClientProvidedTransactionLocation getLocation() {
        return this.location;
    }

    public void setLocation(ClientProvidedTransactionLocation location) {
        this.location = location;
    }

    public ClientProvidedTransaction mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Merchant category codes (MCCs) are four-digit numbers that describe a merchant's primary business activities.")
    public String getMcc() {
        return this.mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public ClientProvidedTransaction datePosted(LocalDate datePosted) {
        this.datePosted = datePosted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date the transaction posted, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format.")
    public LocalDate getDatePosted() {
        return this.datePosted;
    }

    public void setDatePosted(LocalDate datePosted) {
        this.datePosted = datePosted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientProvidedTransaction clientProvidedTransaction = (ClientProvidedTransaction)o;
        return Objects.equals(this.id, clientProvidedTransaction.id) && Objects.equals(this.clientUserId, clientProvidedTransaction.clientUserId) && Objects.equals(this.clientAccountId, clientProvidedTransaction.clientAccountId) && Objects.equals(this.accountType, clientProvidedTransaction.accountType) && Objects.equals(this.accountSubtype, clientProvidedTransaction.accountSubtype) && Objects.equals(this.description, clientProvidedTransaction.description) && Objects.equals(this.amount, clientProvidedTransaction.amount) && Objects.equals((Object)this.direction, (Object)clientProvidedTransaction.direction) && Objects.equals(this.isoCurrencyCode, clientProvidedTransaction.isoCurrencyCode) && Objects.equals(this.location, clientProvidedTransaction.location) && Objects.equals(this.mcc, clientProvidedTransaction.mcc) && Objects.equals(this.datePosted, clientProvidedTransaction.datePosted);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.clientUserId, this.clientAccountId, this.accountType, this.accountSubtype, this.description, this.amount, this.direction, this.isoCurrencyCode, this.location, this.mcc, this.datePosted});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClientProvidedTransaction {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    clientAccountId: ").append(this.toIndentedString(this.clientAccountId)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    accountSubtype: ").append(this.toIndentedString(this.accountSubtype)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    datePosted: ").append(this.toIndentedString(this.datePosted)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

